/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.version;

import com.atlassian.greenhopper.manager.AbstractAOMapper;
import com.atlassian.greenhopper.manager.version.VersionMetaDataAO;
import com.atlassian.greenhopper.model.rapid.LegacyVersionMetaDataImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class VersionMetaDataAOMapper
extends AbstractAOMapper<VersionMetaDataAO, LegacyVersionMetaDataImpl> {
    @Override
    @Nonnull
    public Map<String, Object> toAO(LegacyVersionMetaDataImpl model) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VERSION_ID", model.getVersionId());
        map.put("START_DATE", VersionMetaDataAOMapper.convertStartDate(model.getStartDate()));
        return map;
    }

    @Override
    @Nonnull
    public LegacyVersionMetaDataImpl toModel(VersionMetaDataAO versionMetaDataAO) {
        Date startDate = VersionMetaDataAOMapper.convertStartDate(versionMetaDataAO.getStartDate());
        return LegacyVersionMetaDataImpl.builder().id(versionMetaDataAO.getId()).versionId(versionMetaDataAO.getVersionId()).startDate(startDate).build();
    }

    @Override
    public void update(LegacyVersionMetaDataImpl source, VersionMetaDataAO target) {
        target.setVersionId(source.getVersionId());
        target.setStartDate(VersionMetaDataAOMapper.convertStartDate(source.getStartDate()));
    }

    static Date convertStartDate(Long startDateMillis) {
        Date startDate = null;
        if (startDateMillis != null) {
            startDate = new Date(startDateMillis);
        }
        return startDate;
    }

    static Long convertStartDate(Date startDate) {
        if (startDate == null) {
            return null;
        }
        return startDate.getTime();
    }
}

