/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.version;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.version.VersionMetaDataManagerImpl;
import com.atlassian.greenhopper.project.version.VersionMetaData;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionAdapterFactory {
    private static final int JIRA_6_0_BUILD_NUMBER = 6072;
    private static final String KEY_GREENHOPPER_JIRA_60_VERSION_MIGRATION = "GreenHopper.JIRA60.Version.Migration";
    private static final LoggerWrapper log = LoggerWrapper.with(VersionAdapterFactory.class);
    @Autowired
    private BuildUtilsInfo buildUtilsInfo;
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private VersionMetaDataManagerImpl ghVersionMetaDataManagerImpl;
    @Autowired
    private VersionManager versionManager;

    private boolean isJiraStartDateAvailable() {
        int applicationBuildNumber = this.buildUtilsInfo.getApplicationBuildNumber();
        return applicationBuildNumber >= 6072;
    }

    public void migrate() {
        if (!this.isJiraStartDateAvailable() || this.hasMigrationCompleted()) {
            if (!this.isJiraStartDateAvailable() && this.hasMigrationCompleted()) {
                log.info("JIRA downgrade detected, prepare for migration after upgrade", new Object[0]);
                this.setMigrationCompleted(false);
            }
            return;
        }
        log.info("Begin JIRA start dates for versions migration", new Object[0]);
        Collection versions = this.versionManager.getAllVersions();
        for (Version version : versions) {
            VersionMetaData metaData = this.ghVersionMetaDataManagerImpl.get(version);
            try {
                this.versionManager.editVersionStartDate(version, metaData.getStartDate());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Migration of version '%s' (%d) failed: %s", version.getName(), version.getId(), ex.getMessage());
            }
        }
        this.setMigrationCompleted(true);
        log.info("Done migrating JIRA start dates for versions", new Object[0]);
        this.ghVersionMetaDataManagerImpl.flushCache();
    }

    private boolean hasMigrationCompleted() {
        Boolean value = this.propertyDao.getBooleanProperty(KEY_GREENHOPPER_JIRA_60_VERSION_MIGRATION);
        return value != null && value != false;
    }

    private void setMigrationCompleted(boolean newValue) {
        this.propertyDao.setBooleanProperty(KEY_GREENHOPPER_JIRA_60_VERSION_MIGRATION, newValue);
    }
}

