/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.trackingstatistic;

import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticAO;
import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticAOMapper;
import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticDao;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrackingStatisticManager {
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private TrackingStatisticDao trackingStatisticDao;
    @Autowired
    private TrackingStatisticAOMapper trackingStatisticAOMapper;

    public StatisticsFieldConfig getTrackingStatistic(RapidView rapidView) {
        TrackingStatisticAO trackingStatisticAO = this.trackingStatisticDao.getOne(rapidView.getId());
        if (trackingStatisticAO == null) {
            return StatisticsFieldConfig.buildNone();
        }
        return this.trackingStatisticAOMapper.toModel(trackingStatisticAO);
    }

    public ServiceOutcome<StatisticsFieldConfig> updateTrackingStatistic(RapidView rapidView, StatisticsFieldConfig TrackingStatistic) {
        ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
        if (!rapidViewAO.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewAO);
        }
        TrackingStatisticAO updated = this.trackingStatisticDao.updateOne((RapidViewAO)rapidViewAO.getValue(), TrackingStatistic);
        return ServiceOutcomeImpl.ok(this.trackingStatisticAOMapper.toModel(updated));
    }

    public ServiceOutcome<StatisticsFieldConfig> copy(RapidView sourceRapidView, RapidView targetRapidView) {
        StatisticsFieldConfig trackingStatistic = this.getTrackingStatistic(sourceRapidView);
        return this.updateTrackingStatistic(targetRapidView, trackingStatistic);
    }

    public void deleteTrackingStatistics(RapidViewAO rapidViewAO) {
        this.trackingStatisticDao.deleteForParent(rapidViewAO);
    }
}

