/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.trackingstatistic;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticAO;
import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticAOListMapper;
import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticAOMapper;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.ObjectNotFoundException;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrackingStatisticDao
extends GenericActiveObjectsDao<Long, TrackingStatisticAO>
implements RelatedEntityDao<Long, RapidViewAO, TrackingStatisticAO, StatisticsFieldConfig> {
    @Autowired
    private TrackingStatisticAOMapper trackingStatisticAOMapper;

    @Nonnull
    public TrackingStatisticAO[] getForParent(RapidViewAO rapidViewAO) {
        return this.getForParent(rapidViewAO.getId());
    }

    public TrackingStatisticAO[] getForParent(Long primaryKey) {
        return (TrackingStatisticAO[])this.ao.find(TrackingStatisticAO.class, "RAPID_VIEW_ID = ?", new Object[]{primaryKey});
    }

    public TrackingStatisticAO getOne(Long rapidViewId) {
        TrackingStatisticAO[] trackingStatisticAOs = this.getForParent(rapidViewId);
        if (trackingStatisticAOs.length == 0) {
            return null;
        }
        return trackingStatisticAOs[0];
    }

    @Override
    @Nonnull
    public List<TrackingStatisticAO> updateForParent(RapidViewAO rapidViewAO, List<StatisticsFieldConfig> models) {
        return AOUtil.setListValues(this.ao, new TrackingStatisticAOListMapper(rapidViewAO, this.trackingStatisticAOMapper), models);
    }

    @Nonnull
    public TrackingStatisticAO updateOne(RapidViewAO rapidViewAO, StatisticsFieldConfig trackingStatistic) {
        List<TrackingStatisticAO> trackingStatistics = AOUtil.setListValues(this.ao, new TrackingStatisticAOListMapper(rapidViewAO, this.trackingStatisticAOMapper), Collections.singletonList(trackingStatistic));
        if (trackingStatistics.isEmpty()) {
            ObjectNotFoundException e = new ObjectNotFoundException(String.format("After updating estimation statistic config '%s' we are left with no trackingStatisticAO records for rapid view id=%d", ToStringBuilder.reflectionToString((Object)trackingStatistic), rapidViewAO.getId()));
            this.log.exception(e);
            throw e;
        }
        return trackingStatistics.get(0);
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        TrackingStatisticAO[] trackingStatisticAOs = rapidViewAO.getTrackingStatistics();
        if (trackingStatisticAOs != null) {
            this.delete(trackingStatisticAOs);
        }
    }
}

