/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rapidview;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.events.board.BoardEventPublisher;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.GreenHopperCache;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutFieldDao;
import com.atlassian.greenhopper.manager.cardlayout.CardLayoutManager;
import com.atlassian.greenhopper.manager.color.CardColorDao;
import com.atlassian.greenhopper.manager.color.CardColorManager;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldDao;
import com.atlassian.greenhopper.manager.detailview.DetailViewFieldManager;
import com.atlassian.greenhopper.manager.estimatestatistic.EstimateStatisticManager;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminManager;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.manager.rapidview.events.DaysInColumnSwitchedOff;
import com.atlassian.greenhopper.manager.rapidview.events.DaysInColumnSwitchedOn;
import com.atlassian.greenhopper.manager.rapidview.events.EpicsSwitchedOff;
import com.atlassian.greenhopper.manager.rapidview.events.EpicsSwitchedOn;
import com.atlassian.greenhopper.manager.trackingstatistic.TrackingStatisticManager;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysDao;
import com.atlassian.greenhopper.manager.workingdays.WorkingDaysManager;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.CardColorStrategy;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.ShowEpics;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.rapid.SwimlaneStrategy;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.BoardPropertyService;
import com.atlassian.greenhopper.service.rapid.RapidViewCacheManager;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminDao;
import com.atlassian.greenhopper.service.rapid.view.ColumnAOMapper;
import com.atlassian.greenhopper.service.rapid.view.ColumnDao;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterAOMapper;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterDao;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAOMapper;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPresetService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSimpleQuery;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldDao;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneAOMapper;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneDao;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldConfigurationService;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryAOMapper;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryDao;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryManager;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.greenhopper.util.BoardAdminUtils;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserKeyService;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewManagerImpl
implements RapidViewManager,
GreenHopperCache {
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private RapidViewAOMapper rapidViewAOMapper;
    @Autowired
    private SwimlaneDao swimlaneDao;
    @Autowired
    private SwimlaneAOMapper swimlaneAOMapper;
    @Autowired
    private ColumnDao columnDao;
    @Autowired
    private ColumnAOMapper columnAOMapper;
    @Autowired
    private QuickFilterDao quickFilterDao;
    @Autowired
    private QuickFilterAOMapper quickFilterAOMapper;
    @Autowired
    private CardColorDao cardColorDao;
    @Autowired
    private CardColorManager cardColorManager;
    @Autowired
    private DetailViewFieldDao detailViewFieldDao;
    @Autowired
    private WorkingDaysManager workingDaysManager;
    @Autowired
    private WorkingDaysDao workingDaysDao;
    @Autowired
    private UserKeyService userKeyService;
    @Autowired
    private DetailViewFieldManager detailViewFieldManager;
    @Autowired
    private StatisticsFieldDao statisticsFieldDao;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private SwimlaneService swimlaneService;
    @Autowired
    private QuickFilterService quickFilterService;
    @Autowired
    private StatisticsFieldService statisticsFieldService;
    @Autowired
    private RapidViewPresetService rapidViewPresetService;
    @Autowired
    private SubqueryManager subqueryManager;
    @Autowired
    private SubqueryDao subqueryDao;
    @Autowired
    private SubqueryAOMapper subqueryAOMapper;
    @Autowired
    private EstimateStatisticManager estimateStatisticManager;
    @Autowired
    private TrackingStatisticManager trackingStatisticManager;
    @Autowired
    private DetailViewFieldConfigurationService detailViewFieldConfigurationService;
    @Autowired
    private BoardAdminDao boardAdminDao;
    @Autowired
    private CardLayoutFieldDao cardLayoutFieldDao;
    @Autowired
    private CardLayoutManager cardLayoutManager;
    @Autowired
    private RapidViewCacheManager rapidViewCacheManager;
    @Autowired
    private BoardAdminManager boardAdminManager;
    @Autowired
    private BoardEventPublisher boardEventPublisher;
    @Autowired
    private JsonEntityPropertyManager jsonEntityPropertyManager;
    @Autowired
    private EventPublisher eventPublisher;
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());

    @Override
    public ServiceOutcome<RapidView> create(RapidView view, ApplicationUser user, RapidViewPreset preset) {
        ErrorCollection errors = new ErrorCollection();
        this.validateName(view.getName(), errors);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        view = RapidView.builder(view).showEpicAsPanel(ShowEpics.YES).build();
        RapidViewAO rapidViewAO = (RapidViewAO)this.rapidViewDao.create(this.rapidViewAOMapper.toAO(view));
        RapidView newRapidView = this.rapidViewAOMapper.toModel(rapidViewAO);
        this.swimlaneDao.updateForParent(rapidViewAO, this.rapidViewPresetService.createDefaultSwimlanes(preset));
        this.columnDao.updateForParent(rapidViewAO, this.rapidViewPresetService.createDefaultColumns(user, view, preset));
        this.quickFilterDao.updateForParent(rapidViewAO, this.rapidViewPresetService.createDefaultQuickFilters(preset));
        this.statisticsFieldDao.updateStatisticsField(rapidViewAO, this.rapidViewPresetService.createDefaultStatisticsField(preset));
        this.subqueryDao.updateForParent(rapidViewAO, this.rapidViewPresetService.createDefaultSubqueries(preset));
        this.estimateStatisticManager.updateEstimateStatistic(newRapidView, this.rapidViewPresetService.createDefaultEstimationStatisticConfig(preset));
        this.trackingStatisticManager.updateTrackingStatistic(newRapidView, this.rapidViewPresetService.createDefaultTrackingStatisticConfig(preset));
        this.workingDaysManager.update(newRapidView, this.rapidViewPresetService.createDefaultWorkingDaysConfig(user, preset));
        this.detailViewFieldConfigurationService.createDefaultRapidViewFields(user, newRapidView);
        List<BoardAdmin> boardAdminsList = Collections.singletonList(this.createUserAdmin(ApplicationUsers.getKeyFor((ApplicationUser)user)));
        ServiceOutcome<List<BoardAdmin>> boardAdminOutcome = this.boardAdminManager.updateBoardAdmin(newRapidView, boardAdminsList);
        if (boardAdminOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(boardAdminOutcome);
        }
        this.rapidViewCacheManager.remove(newRapidView.getId());
        this.boardEventPublisher.publishBoardCreated(newRapidView);
        return ServiceOutcomeImpl.ok(newRapidView);
    }

    @Override
    public ServiceOutcome<RapidView> create(ApplicationUser user, String name, Long filterId, RapidViewPreset preset) {
        RapidView view = RapidView.builder().name(name).savedFilterId(filterId).owner(ApplicationUsers.getKeyFor((ApplicationUser)user)).sprintSupportEnabled(this.rapidViewPresetService.isSprintSupportEnabled(preset)).swimlaneStrategy(this.rapidViewPresetService.getDefaultSwimlaneStrategy(preset)).cardColorStrategy(this.rapidViewPresetService.getDefaultCardColorStrategy(preset)).showDaysInColumn(this.rapidViewPresetService.getDefaultShowDaysInColumnConfig(preset)).oldDoneIssuesCutoff(this.rapidViewPresetService.getDefaultOldDoneIssuesCutoff(preset)).build();
        return this.create(view, user, preset);
    }

    @Override
    public ServiceOutcome<Void> delete(RapidView view) {
        ServiceOutcome outcome = this.rapidViewDao.load(view.getId());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        RapidViewAO rapidViewAO = (RapidViewAO)outcome.getValue();
        this.swimlaneDao.deleteForParent(rapidViewAO);
        this.swimlaneService.invalidate(view);
        this.columnDao.deleteForParent(rapidViewAO);
        this.columnService.invalidate(view);
        this.statisticsFieldDao.deleteStatisticsField(rapidViewAO);
        this.statisticsFieldService.invalidate(view);
        this.quickFilterDao.deleteForParent(rapidViewAO);
        this.quickFilterService.invalidate(view);
        this.subqueryDao.deleteForParent(rapidViewAO);
        this.subqueryManager.invalidateCache(view);
        this.estimateStatisticManager.deleteEstimateStatistics(rapidViewAO);
        this.trackingStatisticManager.deleteTrackingStatistics(rapidViewAO);
        this.cardColorDao.deleteForParent(rapidViewAO);
        this.cardColorManager.invalidate(view);
        this.detailViewFieldDao.deleteForParent(rapidViewAO);
        this.detailViewFieldManager.invalidate(view);
        this.workingDaysDao.deleteForParent(rapidViewAO);
        this.boardAdminDao.deleteForParent(rapidViewAO);
        this.boardAdminManager.invalidate(view);
        this.cardLayoutFieldDao.deleteForParent(rapidViewAO);
        this.cardLayoutManager.invalidate(view);
        this.jsonEntityPropertyManager.deleteByEntity(BoardPropertyService.BOARD_ENTITY_PROPERTY_TYPE.getDbEntityName(), Long.valueOf(rapidViewAO.getId()));
        this.rapidViewDao.delete(view.getId());
        this.removeFromCache(view);
        this.boardEventPublisher.publishBoardDeleted(view);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> update(RapidView view) {
        ErrorCollection errors = new ErrorCollection();
        this.validateName(view.getName(), errors);
        this.validateSwimlaneStrategy(view.getSwimlaneStrategy(), errors);
        this.validateCardColorStrategy(view.getCardColorStrategy(), errors);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        ServiceOutcome oldValue = this.rapidViewDao.load(view.getId());
        ServiceOutcome<RapidViewAO> outcome = this.rapidViewDao.update(view);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "failed to load view with id '%d' from cache even though it was just created", outcome.getValue().getId());
        }
        this.removeFromCache(view);
        if (outcome.isValid() && oldValue.isValid()) {
            RapidView rapidView;
            RapidView oldRapidView = this.rapidViewAOMapper.toModel((RapidViewAO)oldValue.get());
            if (this.hasChangedName(oldRapidView, rapidView = this.rapidViewAOMapper.toModel(outcome.get()))) {
                this.boardEventPublisher.publishBoardUpdatedEvent(this.rapidViewAOMapper.toModel(outcome.get()));
            }
            if (this.hasChangedConfiguration(oldRapidView, rapidView)) {
                this.boardEventPublisher.publishBoardConfigurationChangedEvent(this.rapidViewAOMapper.toModel(outcome.get()));
            }
            if (this.columnService.isKanPlanEnabledForBoard(rapidView) && Objects.nonNull((Object)rapidView.getShowEpicsAsPanel()) && Objects.nonNull((Object)oldRapidView.getShowEpicsAsPanel())) {
                if (rapidView.getShowEpicsAsPanel().isEnabled() && !oldRapidView.getShowEpicsAsPanel().isEnabled()) {
                    this.eventPublisher.publish((Object)new EpicsSwitchedOn(rapidView.getId().toString()));
                } else if (!rapidView.getShowEpicsAsPanel().isEnabled() && oldRapidView.getShowEpicsAsPanel().isEnabled()) {
                    this.eventPublisher.publish((Object)new EpicsSwitchedOff(rapidView.getId().toString()));
                }
            }
            if (rapidView.showDaysInColumn() != oldRapidView.showDaysInColumn()) {
                if (rapidView.showDaysInColumn()) {
                    this.eventPublisher.publish((Object)new DaysInColumnSwitchedOn(rapidView.getId()));
                } else {
                    this.eventPublisher.publish((Object)new DaysInColumnSwitchedOff(rapidView.getId()));
                }
            }
        }
        return ServiceOutcomeImpl.ok();
    }

    private boolean hasChangedName(RapidView oldValue, RapidView updatedValue) {
        return !Objects.equals(oldValue.getName(), updatedValue.getName());
    }

    private boolean hasChangedConfiguration(RapidView oldValue, RapidView updatedValue) {
        return !Objects.equals(oldValue.getSavedFilterId(), updatedValue.getSavedFilterId());
    }

    @Override
    public ServiceOutcome<RapidView> getFirst(RapidViewManager.RapidViewPermissionCheck permissionCheck) {
        AtomicReference rapidViewFound = new AtomicReference();
        Consumer<RapidViewAO> permissionChecker = rapidViewAO -> {
            RapidView rapidView;
            if (rapidViewFound.get() == null && (rapidView = this.rapidViewAOMapper.toModel((RapidViewAO)rapidViewAO)) != null && permissionCheck.check(rapidView)) {
                rapidViewFound.set(rapidView);
            }
        };
        this.rapidViewDao.loadAll(permissionChecker);
        RapidView rapidViewObject = (RapidView)rapidViewFound.get();
        if (rapidViewObject != null) {
            return ServiceOutcomeImpl.ok(rapidViewFound.get());
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.noview", new Object[0]);
    }

    @Override
    public ServiceOutcome<List<RapidView>> getAll(RapidViewManager.RapidViewPermissionCheck permissionCheck) {
        List<RapidView> result = this.getAllRapidViews();
        Iterator<RapidView> iter = result.iterator();
        while (iter.hasNext()) {
            if (permissionCheck.check(iter.next())) continue;
            iter.remove();
        }
        return ServiceOutcomeImpl.ok(result);
    }

    @Override
    public ServiceOutcome<List<RapidView>> getAll() {
        return ServiceOutcomeImpl.ok(this.getAllRapidViews());
    }

    private List<RapidView> getAllRapidViews() {
        LinkedList<RapidView> result = new LinkedList<RapidView>();
        Consumer<RapidViewAO> addToResult = rapidViewAO -> result.add(this.rapidViewAOMapper.toModel((RapidViewAO)rapidViewAO));
        this.rapidViewDao.loadAll(addToResult);
        return result;
    }

    @Override
    public ServiceOutcome<Iterable<RapidView>> find(RapidViewSimpleQuery rapidViewSimpleQuery) {
        RapidViewSimpleQuery rapidViewTypesQuery = RapidViewSimpleQuery.forTypes(rapidViewSimpleQuery.getTypes());
        List<RapidViewAO> rapidViewAOs = this.rapidViewDao.find(rapidViewTypesQuery);
        Iterable filteredRapidViews = Iterables.filter(rapidViewAOs, this.filterRapidBoards(rapidViewSimpleQuery));
        ArrayList rapidViews = Lists.newArrayList((Iterable)Iterables.transform((Iterable)filteredRapidViews, rapidViewAO -> this.rapidViewAOMapper.toModel((RapidViewAO)rapidViewAO)));
        return ServiceOutcomeImpl.ok(rapidViews);
    }

    private Predicate<RapidViewAO> filterRapidBoards(RapidViewSimpleQuery rapidViewSimpleQuery) {
        return rapidViewAO -> {
            if (rapidViewAO == null) {
                return false;
            }
            String partialName = rapidViewSimpleQuery.getPartialName();
            if (StringUtils.isBlank((CharSequence)partialName)) {
                return true;
            }
            String rapidViewName = rapidViewAO.getName();
            String partialNameLowerCase = partialName.toLowerCase();
            boolean matchesBoardName = rapidViewName != null && rapidViewName.toLowerCase().contains(partialNameLowerCase);
            return matchesBoardName || rapidViewSimpleQuery.shouldFilterByBoardAdmin() != false && this.matchesAdminName((RapidViewAO)rapidViewAO, partialNameLowerCase);
        };
    }

    private boolean matchesAdminName(RapidViewAO rapidViewAO, String partialName) {
        List<BoardAdmin> boardAdmins = this.boardAdminManager.getBoardAdmins(rapidViewAO.getId());
        return boardAdmins.stream().map(this::tryToExtractUserName).filter(Objects::nonNull).map(String::toLowerCase).anyMatch(boardName -> boardName.contains(partialName));
    }

    private String tryToExtractUserName(BoardAdmin boardAdmin) {
        String userName = this.userKeyService.getUsernameForKey(boardAdmin.getKey());
        return userName != null ? userName : boardAdmin.getKey();
    }

    @Override
    public ServiceOutcome<RapidView> copy(RapidView sourceRapidView, RapidView destinationRapidView, ApplicationUser creator) {
        ErrorCollection errors = new ErrorCollection();
        this.validateName(destinationRapidView.getName(), errors);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        RapidViewAO rapidViewAO = (RapidViewAO)this.rapidViewDao.create(this.rapidViewAOMapper.toAO(destinationRapidView));
        RapidView copiedRapidView = this.rapidViewAOMapper.toModel(rapidViewAO);
        for (Swimlane swimlane : this.swimlaneService.loadSwimlanes(sourceRapidView)) {
            Swimlane swimlane2 = Swimlane.builder(swimlane).id(null).build();
            this.swimlaneDao.create(this.swimlaneAOMapper.toAO(rapidViewAO, swimlane2));
        }
        int position = 0;
        for (Column sourceColumn : this.columnService.getVisibleColumns(sourceRapidView)) {
            Column column = Column.builder(sourceColumn).id(null).build();
            this.columnDao.createWithStatuses(this.columnAOMapper.toAO(rapidViewAO, column), column.getStatusIds(), position++);
        }
        for (QuickFilter sourceQuickFilter : this.quickFilterService.loadQuickFilters(sourceRapidView)) {
            QuickFilter quickFilter = QuickFilter.builder(sourceQuickFilter).id(null).build();
            this.quickFilterDao.create(this.quickFilterAOMapper.toAO(rapidViewAO, quickFilter));
        }
        Subquery subquery = this.subqueryManager.getSubquery(sourceRapidView);
        Subquery subquery2 = Subquery.builder(subquery).id(null).build();
        this.subqueryDao.create(this.subqueryAOMapper.toAO(rapidViewAO, subquery2));
        this.estimateStatisticManager.copy(sourceRapidView, copiedRapidView);
        this.trackingStatisticManager.copy(sourceRapidView, copiedRapidView);
        ServiceOutcome<StatisticsFieldConfig> sourceConfig = this.statisticsFieldService.loadStatisticsField(sourceRapidView);
        if (!sourceConfig.isValid()) {
            return ServiceOutcomeImpl.error(sourceConfig);
        }
        StatisticsFieldConfig config = new StatisticsFieldConfig.StatisticsFieldConfigBuilder(sourceConfig.getValue()).id(null).build();
        this.statisticsFieldDao.updateStatisticsField(rapidViewAO, config);
        this.cardColorManager.copy(sourceRapidView, copiedRapidView);
        this.detailViewFieldManager.copy(sourceRapidView, copiedRapidView);
        this.workingDaysManager.copy(sourceRapidView, copiedRapidView);
        this.cardLayoutManager.copy(sourceRapidView, copiedRapidView);
        List<BoardAdmin> boardAdmins = BoardAdminUtils.mergeAdmins(this.boardAdminManager.getBoardAdmins(sourceRapidView), this.createUserAdmin(ApplicationUsers.getKeyFor((ApplicationUser)creator)));
        ServiceOutcome<List<BoardAdmin>> outcome = this.boardAdminManager.setBoardAdmin(copiedRapidView, boardAdmins);
        if (outcome.isInvalid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        this.boardEventPublisher.publishBoardCreated(copiedRapidView);
        return ServiceOutcomeImpl.ok(copiedRapidView);
    }

    @Override
    public ServiceOutcome<RapidView> get(Long id) {
        Option<RapidView> rapidView = this.rapidViewCacheManager.get(id);
        if (!rapidView.isDefined()) {
            return ServiceOutcomeImpl.error("rapidViewId", ErrorCollection.Reason.NOT_FOUND, "gh.rapid.view.error.noview", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(rapidView.get());
    }

    @Override
    public List<RapidView> findByFilterId(long filterId) {
        return this.rapidViewDao.findByFilterId(filterId).stream().map(this.rapidViewAOMapper::toModel).collect(Collectors.toList());
    }

    @Override
    public void flushCache() {
        this.rapidViewCacheManager.removeAll();
    }

    private void validateName(String name, ErrorCollection errors) {
        if (StringUtils.isBlank((CharSequence)name)) {
            errors.addContextualError("name", "gh.rapid.view.error.name.required", new Object[0]);
            return;
        }
        if (name.length() > 255) {
            errors.addContextualError("name", "gh.rapid.view.error.name.toobig", 255);
        }
    }

    private void validateSwimlaneStrategy(SwimlaneStrategy swimlaneStrategy, ErrorCollection errors) {
        Set<SwimlaneStrategy> validStrategies = this.swimlaneService.getValidStrategies();
        if (swimlaneStrategy == null || !validStrategies.contains((Object)swimlaneStrategy)) {
            String swimlaneStrategyId = swimlaneStrategy == null ? "null" : swimlaneStrategy.getId();
            errors.addContextualError("swimlaneStrategy", "gh.rapid.view.error.swimlane.strategy.invalid", swimlaneStrategyId);
        }
    }

    private void validateCardColorStrategy(CardColorStrategy cardColorStrategy, ErrorCollection errors) {
        List<CardColorStrategy> validStrategies = Arrays.asList(CardColorStrategy.values());
        if (cardColorStrategy == null || !validStrategies.contains((Object)cardColorStrategy)) {
            String cardColorStrategyId = cardColorStrategy == null ? "null" : cardColorStrategy.getId();
            errors.addContextualError("cardColorStrategy", "gh.rapid.view.error.cardcolor.strategy.invalid", cardColorStrategyId);
        }
    }

    private void removeFromCache(RapidView view) {
        this.log.debug("Removing from cache RapidView[id=%d]", view.getId());
        this.rapidViewCacheManager.remove(view.getId());
    }

    private BoardAdmin createUserAdmin(String userKey) {
        return BoardAdmin.builder().key(userKey).type(BoardAdmin.Type.USER).build();
    }
}

