/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rapidview;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminListToMapMapper;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardAdminValidator {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final GroupManager groupManager;
    private final BoardAdminListToMapMapper boardAdminListToMapMapper;

    @Autowired
    public BoardAdminValidator(GroupManager groupManager, BoardAdminListToMapMapper boardAdminListToMapMapper) {
        this.groupManager = groupManager;
        this.boardAdminListToMapMapper = boardAdminListToMapMapper;
    }

    public Predicate<BoardAdmin> getValidBoardAdminsPredicate(@NotNull Map<BoardAdmin.Type, Set<String>> existingAdmins) {
        return boardAdmin -> this.isBoardAdminValid(existingAdmins, boardAdmin.getType(), boardAdmin.getKey());
    }

    public boolean isBoardAdminValid(@NotNull Map<BoardAdmin.Type, Set<String>> existingAdmins, @NotNull BoardAdmin.Type type, String key) {
        return this.boardAdminAlreadySet(existingAdmins, type, key) || this.boardAdminExists(type, key);
    }

    public List<BoardAdmin> filterValidAdmins(List<BoardAdmin> newBoardAdmins, List<BoardAdmin> currentAdmins) {
        Map<BoardAdmin.Type, Set<String>> existingAdmins = this.boardAdminListToMapMapper.apply(currentAdmins);
        List<BoardAdmin> validAdmins = newBoardAdmins.stream().filter(this.getValidBoardAdminsPredicate(existingAdmins)).collect(Collectors.toList());
        if (validAdmins.size() != newBoardAdmins.size()) {
            this.log.info("Filtered out invalid admins: " + ListUtils.subtract(newBoardAdmins, validAdmins), new Object[0]);
        }
        return validAdmins;
    }

    private boolean boardAdminAlreadySet(@NotNull Map<BoardAdmin.Type, Set<String>> boardAdmins, @NotNull BoardAdmin.Type type, String key) {
        return boardAdmins.getOrDefault((Object)type, Collections.emptySet()).contains(key);
    }

    private boolean boardAdminExists(BoardAdmin.Type type, String key) {
        return type == BoardAdmin.Type.USER && ApplicationUsers.byKey((String)key) != null || type == BoardAdmin.Type.GROUP && this.groupManager.getGroup(key) != null;
    }
}

