/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rapidview;

import com.atlassian.cache.compat.Cache;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminManager;
import com.atlassian.greenhopper.manager.rapidview.BoardAdminValidator;
import com.atlassian.greenhopper.model.rapid.BoardAdmin;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminAO;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminAOMapper;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminDao;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminRaw;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.atlassian.greenhopper.util.RequestBoundCacheFactory;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoardAdminManagerImpl
implements BoardAdminManager {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String BOARD_ADMINS_CACHE_KEY = BoardAdminManagerImpl.class.getName() + ".boardAdmins";
    @Autowired
    private BoardAdminDao boardAdminDao;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private BoardAdminAOMapper boardAdminAOMapper;
    @Autowired
    private BoardAdminValidator boardAdminValidator;
    @Autowired
    RequestBoundCacheFactory requestBoundCacheFactory;
    @Autowired
    CacheFactoryManager cacheFactoryManager;
    Cache<Long, List<BoardAdmin>> cache;

    @PostConstruct
    public void init() {
        this.cache = this.cacheFactoryManager.create().getCache(BOARD_ADMINS_CACHE_KEY, this::loadBoardAdmins);
    }

    private List<BoardAdmin> loadBoardAdmins(Long id) {
        return ImmutableList.copyOf(this.boardAdminAOMapper.toModel((Collection<? extends BoardAdminRaw>)Arrays.asList(this.boardAdminDao.getForParent(id))));
    }

    @Override
    public List<BoardAdmin> getBoardAdmins(RapidView view) {
        return this.getBoardAdmins(view.getId());
    }

    @Override
    @Nonnull
    public List<BoardAdmin> getBoardAdmins(@Nonnull Long rapidViewId) {
        return this.cache.get(rapidViewId);
    }

    @Override
    public Multimap<RapidView, BoardAdmin> getBoardAdmins(List<RapidView> views) {
        ImmutableMap id2view = Maps.uniqueIndex(views, RapidView::getId);
        Set viewIds = id2view.keySet();
        HashMultimap result = HashMultimap.create();
        for (Long rapidViewId : viewIds) {
            result.putAll(id2view.get(rapidViewId), (Iterable)this.cache.get(rapidViewId));
        }
        return result;
    }

    @Override
    public ServiceOutcome<List<BoardAdmin>> updateBoardAdmin(RapidView rapidView, List<BoardAdmin> boardAdmins) {
        ServiceOutcome serviceOutcome = this.rapidViewDao.load(rapidView.getId());
        if (!serviceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(serviceOutcome);
        }
        List<BoardAdminAO> boardAminAOs = this.boardAdminDao.updateForParent((RapidViewAO)serviceOutcome.getValue(), this.boardAdminValidator.filterValidAdmins(boardAdmins, this.getBoardAdmins(rapidView)));
        this.invalidate(rapidView);
        return ServiceOutcomeImpl.ok(this.boardAdminAOMapper.toModel((Collection<? extends BoardAdminRaw>)boardAminAOs));
    }

    @Override
    public ServiceOutcome<List<BoardAdmin>> setBoardAdmin(@Nonnull RapidView rapidView, @Nonnull List<BoardAdmin> boardAdmins) {
        ServiceOutcome serviceOutcome = this.rapidViewDao.load(rapidView.getId());
        if (!serviceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(serviceOutcome);
        }
        List<BoardAdminAO> boardAminAOs = this.boardAdminDao.updateForParent((RapidViewAO)serviceOutcome.getValue(), boardAdmins);
        this.invalidate(rapidView);
        return ServiceOutcomeImpl.ok(this.boardAdminAOMapper.toModel((Collection<? extends BoardAdminRaw>)boardAminAOs));
    }

    @Override
    public ServiceOutcome<List<BoardAdmin>> appendBoardAdmin(RapidView rapidView, List<BoardAdmin> newBoardAdmins) {
        ServiceOutcome serviceOutcome = this.rapidViewDao.load(rapidView.getId());
        if (!serviceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(serviceOutcome);
        }
        List<BoardAdminAO> boardAminAOs = this.boardAdminDao.appendBoardAdminForParent((RapidViewAO)serviceOutcome.getValue(), this.boardAdminValidator.filterValidAdmins(newBoardAdmins, this.getBoardAdmins(rapidView)));
        this.invalidate(rapidView);
        return ServiceOutcomeImpl.ok(this.boardAdminAOMapper.toModel((Collection<? extends BoardAdminRaw>)boardAminAOs));
    }

    @Override
    public void invalidate(RapidView view) {
        this.cache.remove(view.getId());
    }

    @Override
    public void flushCache() {
        this.cache.removeAll();
    }
}

