/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rankableobject;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.GreenHopperCache;
import com.atlassian.greenhopper.manager.rankableobject.RankableObjectAO;
import com.atlassian.greenhopper.manager.rankableobject.RankableObjectAOMapper;
import com.atlassian.greenhopper.manager.rankableobject.RankableObjectDao;
import com.atlassian.greenhopper.model.rapid.RankableObject;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import io.atlassian.fugue.Option;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankableObjectManager
implements GreenHopperCache {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private RankableObjectDao rankableObjectDao;
    @Autowired
    private RankableObjectAOMapper rankableObjectAOMapper;
    @Autowired
    private CacheFactoryManager cacheManagerFactory;
    private Cache<Long, Option<RankableObject>> rankableObjectCache;

    @PostConstruct
    public void init() {
        this.rankableObjectCache = this.cacheManagerFactory.create().getCache(RankableObjectManager.class.getName() + ".rankableObjectCache", new RankableObjectCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    public ServiceOutcome<RankableObject> createRankableObject(RankableObject rankableObject) {
        Map<String, Object> rankableObjectAOFields = this.rankableObjectAOMapper.toAO(rankableObject);
        RankableObjectAO rankableObjectAO = (RankableObjectAO)this.rankableObjectDao.create(rankableObjectAOFields);
        if (rankableObjectAO == null) {
            this.log.error("Could not create rankableObjectAO with type = " + rankableObject.getType(), new Object[0]);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.rankable.ao.failure", new Object[0]);
        }
        this.rankableObjectCache.remove(rankableObjectAO.getId());
        Option<RankableObject> rankable = this.rankableObjectCache.get(rankableObjectAO.getId());
        if (rankable.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rankable.ao.failure", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(rankable.get());
    }

    public ServiceOutcome<Void> deleteRankableObject(RankableObject rankableObject) {
        this.rankableObjectDao.delete(rankableObject.getId());
        this.rankableObjectCache.remove(rankableObject.getId());
        return ServiceOutcomeImpl.ok();
    }

    public ServiceOutcome<RankableObject> getRankableObject(long id) {
        Option<RankableObject> rankableObject = this.rankableObjectCache.get(id);
        if (rankableObject.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.rankable.not.found", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(rankableObject.get());
    }

    @Override
    public void flushCache() {
        this.rankableObjectCache.removeAll();
    }

    private class RankableObjectCacheLoader
    implements CacheLoader<Long, Option<RankableObject>> {
        private RankableObjectCacheLoader() {
        }

        @Override
        public Option<RankableObject> load(@Nonnull Long rankableObjectId) {
            ServiceOutcome rankableObjectAO = RankableObjectManager.this.rankableObjectDao.load(rankableObjectId);
            if (rankableObjectAO.isInvalid()) {
                return Option.none();
            }
            return Option.some((Object)RankableObjectManager.this.rankableObjectAOMapper.toModel((RankableObjectAO)rankableObjectAO.getValue()));
        }
    }
}

