/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInstruction;

public class UpdateRowInstruction
extends BaseInstruction {
    final Long oldNextIssueId;
    final Long newNextIssueId;

    public UpdateRowInstruction(ActiveObjects ao, Long customFieldId, Long issueId, Long oldNextIssueId, Long newNextIssueId) {
        super(ao, customFieldId, issueId);
        this.oldNextIssueId = oldNextIssueId;
        this.newNextIssueId = newNextIssueId;
    }

    @Override
    public void sanityCheck() {
        IssueRankingAO rowToUpdate = this.findIssueRankingAO(this.customFieldId, this.issueId);
        if (rowToUpdate == null) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for setting nextId of issue %d and custom field %d from %d to %d failed. No entry for issue %d found", this.issueId, this.customFieldId, this.oldNextIssueId, this.newNextIssueId, this.issueId));
        }
        Long dbNextId = rowToUpdate.getNextId();
        if (!UpdateRowInstruction.compareLongValues(dbNextId, this.oldNextIssueId) && !UpdateRowInstruction.compareLongValues(dbNextId, this.newNextIssueId)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for setting nextId of issue %d and custom field %d from %d to %d failed. Current value is %d", this.issueId, this.customFieldId, this.oldNextIssueId, this.newNextIssueId, dbNextId));
        }
    }

    @Override
    public void execute() {
        IssueRankingAO rowToUpdate = this.loadIssueRanking(this.customFieldId, this.issueId);
        Long dbNextId = rowToUpdate.getNextId();
        if (!UpdateRowInstruction.compareLongValues(dbNextId, this.oldNextIssueId) && !UpdateRowInstruction.compareLongValues(dbNextId, this.newNextIssueId)) {
            throw new IllegalStateException(String.format("Attempted to update nextId of issue %d and custom field %d from %d to %d but current value is %d", this.issueId, this.customFieldId, this.oldNextIssueId, this.newNextIssueId, dbNextId));
        }
        rowToUpdate.setNextId(this.newNextIssueId);
        rowToUpdate.save();
    }

    @Override
    public String getBeforeState() {
        return this.issueId + " -> " + this.oldNextIssueId;
    }

    @Override
    public String getAfterState() {
        return this.issueId + " -> " + this.newNextIssueId;
    }

    public Long getOldNextIssueId() {
        return this.oldNextIssueId;
    }

    public Long getNewNextIssueId() {
        return this.newNextIssueId;
    }
}

