/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.Instruction;
import net.java.ao.Query;

public class TopOfChainCheck
extends Instruction {
    final Long customFieldId;
    private final Long headIssueId;
    private final Long possibleParentId;

    public TopOfChainCheck(ActiveObjects ao, Long customFieldId, Long headIssueId, Long possibleParentIssueId) {
        super(ao);
        this.customFieldId = customFieldId;
        this.headIssueId = headIssueId;
        this.possibleParentId = possibleParentIssueId;
    }

    @Override
    public void sanityCheck() {
        IssueRankingAO[] previousOfHead = (IssueRankingAO[])this.ao.find(IssueRankingAO.class, Query.select().where("NEXT_ID = ? AND CUSTOM_FIELD_ID = ?", new Object[]{this.headIssueId, this.customFieldId}));
        if (previousOfHead == null || previousOfHead.length == 0) {
            return;
        }
        if (previousOfHead.length == 1 && TopOfChainCheck.compareLongValues(this.possibleParentId, previousOfHead[0].getIssueId())) {
            return;
        }
        if (previousOfHead.length == 1) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for chain head failed. Unexpected issue %d pointing to head %d for custom field %d", previousOfHead[0].getIssueId(), this.headIssueId, this.customFieldId));
        }
        throw new RankDaoSanityCheckException(String.format("Sanity check for chain head failed. Multiple issues pointing to head %d for custom field %d", previousOfHead[0].getIssueId(), this.headIssueId, this.customFieldId));
    }

    @Override
    public String getBeforeState() {
        return "issue " + this.headIssueId + " is head of index for custom field " + this.customFieldId;
    }

    public Long getCustomFieldId() {
        return this.customFieldId;
    }

    public Long getHeadIssueId() {
        return this.headIssueId;
    }

    public Long getPossibleParentId() {
        return this.possibleParentId;
    }
}

