/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInstruction;
import net.java.ao.RawEntity;

public class RemoveRowInstruction
extends BaseInstruction {
    final Long oldNextIssueId;

    public RemoveRowInstruction(ActiveObjects ao, Long customFieldId, Long issueId, Long oldNextIssueId) {
        super(ao, customFieldId, issueId);
        this.oldNextIssueId = oldNextIssueId;
    }

    @Override
    public void sanityCheck() {
        IssueRankingAO issueRankingAO = this.findIssueRankingAO(this.customFieldId, this.issueId);
        if (issueRankingAO == null) {
            return;
        }
        Long dbNextId = issueRankingAO.getNextId();
        if (!RemoveRowInstruction.compareLongValues(dbNextId, this.oldNextIssueId)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for removing entry for issue %d, nextId %d and custom field %d failed. NextId is %d", this.issueId, this.oldNextIssueId, this.customFieldId, dbNextId));
        }
    }

    @Override
    public void execute() {
        IssueRankingAO issueRankingAO = this.findIssueRankingAO(this.customFieldId, this.issueId);
        if (issueRankingAO == null) {
            return;
        }
        Long dbNextId = issueRankingAO.getNextId();
        if (!RemoveRowInstruction.compareLongValues(dbNextId, this.oldNextIssueId)) {
            throw new IllegalStateException(String.format("Removing entry for issue %d, nextId %d and custom field %d failed. NextId is %d", this.issueId, this.oldNextIssueId, this.customFieldId, dbNextId));
        }
        this.ao.delete(new RawEntity[]{issueRankingAO});
    }

    @Override
    public String getBeforeState() {
        return this.issueId + " -> " + this.oldNextIssueId;
    }

    @Override
    public String getAfterState() {
        return "no row for " + this.issueId;
    }

    public Long getOldNextIssueId() {
        return this.oldNextIssueId;
    }
}

