/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInputParametersCheck;

public class RemoveParametersCheck
extends BaseInputParametersCheck {
    private final Long oldPrevious;
    private final Long oldNext;

    public RemoveParametersCheck(ActiveObjects ao, Long customFieldId, Long issueId, Long oldPrevious, Long oldNext) {
        super(ao, customFieldId, issueId);
        this.oldPrevious = oldPrevious;
        this.oldNext = oldNext;
    }

    @Override
    void additionalChecks() {
        if (RemoveParametersCheck.compareLongValues(this.issueId, this.oldPrevious) || RemoveParametersCheck.compareLongValues(this.issueId, this.oldNext)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for issue remove parameters failed. IssueId must not be equal to oldPrevious or oldNext", new Object[0]));
        }
    }

    @Override
    public String getBeforeState() {
        return "issue remove parameters check";
    }

    public Long getOldPrevious() {
        return this.oldPrevious;
    }

    public Long getOldNext() {
        return this.oldNext;
    }
}

