/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInputParametersCheck;

public class MoveParametersCheck
extends BaseInputParametersCheck {
    private final Long oldPrevious;
    private final Long oldNext;
    private final Long newPrevious;
    private final Long newNext;

    public MoveParametersCheck(ActiveObjects ao, Long customFieldId, Long issueId, Long oldPrevious, Long oldNext, Long newPrevious, Long newNext) {
        super(ao, customFieldId, issueId);
        this.oldPrevious = oldPrevious;
        this.oldNext = oldNext;
        this.newPrevious = newPrevious;
        this.newNext = newNext;
    }

    @Override
    void additionalChecks() {
        if (MoveParametersCheck.compareLongValues(this.issueId, this.newPrevious) || MoveParametersCheck.compareLongValues(this.issueId, this.newNext) || MoveParametersCheck.compareLongValues(this.issueId, this.oldPrevious) || MoveParametersCheck.compareLongValues(this.issueId, this.oldNext)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for issue move parameters failed. IssueId must not be equal to oldPrevious, oldNext, newPrevious nor newNext", new Object[0]));
        }
        if (MoveParametersCheck.compareLongValues(this.oldPrevious, this.newPrevious) || MoveParametersCheck.compareLongValues(this.oldNext, this.newNext)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for issue move parameters failed. Operation is a no-op", new Object[0]));
        }
        if (MoveParametersCheck.compareLongValues(this.oldPrevious, this.oldNext) || MoveParametersCheck.compareLongValues(this.newPrevious, this.newNext)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for issue move parameters failed. previous and next must not be equal", new Object[0]));
        }
    }

    @Override
    public String getBeforeState() {
        return "issue move parameters check";
    }

    public Long getOldPrevious() {
        return this.oldPrevious;
    }

    public Long getOldNext() {
        return this.oldNext;
    }

    public Long getNewPrevious() {
        return this.newPrevious;
    }

    public Long getNewNext() {
        return this.newNext;
    }
}

