/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInstruction;
import net.java.ao.Query;

public class LastRowCheck
extends BaseInstruction {
    public LastRowCheck(ActiveObjects ao, Long customFieldId, Long issueId) {
        super(ao, customFieldId, issueId);
    }

    @Override
    public void sanityCheck() {
        IssueRankingAO[] result = (IssueRankingAO[])this.ao.find(IssueRankingAO.class, Query.select().where("CUSTOM_FIELD_ID = ?", new Object[]{this.customFieldId}));
        if (result == null || result.length == 0) {
            return;
        }
        if (result.length > 1) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for last issue in index failed. There should only be one issue for custom field %d, found %d instead", this.customFieldId, result.length));
        }
        if (!LastRowCheck.compareLongValues(result[0].getIssueId(), this.issueId)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for last issue in index failed. There is only one issue, but it is not the one we expected! For custom field %d expected %d, found %d instead", this.customFieldId, this.issueId, result[0].getIssueId()));
        }
        if (!LastRowCheck.compareLongValues(result[0].getNextId(), null)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for last issue in index failed. For custom field %d and issueId %d next points to %d instead of null", this.customFieldId, this.issueId, result[0].getNextId()));
        }
    }

    @Override
    public String getBeforeState() {
        return "last issue  in index for custom field " + this.customFieldId + " should be " + this.issueId;
    }
}

