/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import net.java.ao.Query;

public abstract class Instruction {
    final ActiveObjects ao;

    public Instruction(ActiveObjects ao) {
        this.ao = ao;
    }

    public void sanityCheck() {
    }

    public void execute() {
    }

    public String getBeforeState() {
        return "";
    }

    public String getAfterState() {
        return "";
    }

    IssueRankingAO findIssueRankingAO(Long customFieldId, Long issueId) {
        IssueRankingAO[] result = (IssueRankingAO[])this.ao.find(IssueRankingAO.class, Query.select().where("ISSUE_ID = ? AND CUSTOM_FIELD_ID = ?", new Object[]{issueId, customFieldId}));
        if (result == null || result.length == 0) {
            return null;
        }
        if (result.length == 1) {
            return result[0];
        }
        throw new IllegalStateException(String.format("Found more than one ranking for issue %d and custom field %d", issueId, customFieldId));
    }

    IssueRankingAO loadIssueRanking(Long customFieldId, Long issueId) {
        IssueRankingAO ao = this.findIssueRankingAO(customFieldId, issueId);
        if (ao == null) {
            throw new IllegalStateException(String.format("Couldn't find an entry for issue %d and custom field %d", issueId, customFieldId));
        }
        return ao;
    }

    static boolean compareLongValues(Long a, Long b) {
        return a == null ? b == null : a.equals(b);
    }
}

