/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInstruction;
import net.java.ao.DBParam;

public class InsertRowInstruction
extends BaseInstruction {
    final Long nextIssueId;

    public InsertRowInstruction(ActiveObjects ao, Long customFieldId, Long issueId, Long nextIssueId) {
        super(ao, customFieldId, issueId);
        this.nextIssueId = nextIssueId;
    }

    @Override
    public void sanityCheck() {
        IssueRankingAO issueRankingAO = this.findIssueRankingAO(this.customFieldId, this.issueId);
        if (issueRankingAO == null) {
            return;
        }
        Long dbNextId = issueRankingAO.getNextId();
        if (!InsertRowInstruction.compareLongValues(dbNextId, this.nextIssueId)) {
            throw new RankDaoSanityCheckException(String.format("Create new entry sanity check failed for issue %d, nextId %d and custom field %d. Entry already exists with nextId %d.", this.issueId, this.nextIssueId, this.customFieldId, dbNextId));
        }
    }

    @Override
    public void execute() {
        IssueRankingAO issueRankingAO = this.findIssueRankingAO(this.customFieldId, this.issueId);
        if (issueRankingAO == null) {
            IssueRankingAO newEntry = (IssueRankingAO)this.ao.create(IssueRankingAO.class, new DBParam[]{new DBParam("ISSUE_ID", (Object)this.issueId), new DBParam("NEXT_ID", (Object)this.nextIssueId), new DBParam("CUSTOM_FIELD_ID", (Object)this.customFieldId)});
            if (newEntry == null) {
                throw new IllegalStateException(String.format("Failed to create new entry for issue %d, nextId %d and custom field %d", this.issueId, this.nextIssueId, this.customFieldId));
            }
        } else {
            Long dbNextId = issueRankingAO.getNextId();
            if (!InsertRowInstruction.compareLongValues(dbNextId, this.nextIssueId)) {
                throw new IllegalStateException(String.format("Failed to create new entry for issue %d, nextId %d and custom field %d. Entry already exists with nextId %d", this.issueId, this.nextIssueId, this.customFieldId, dbNextId));
            }
        }
    }

    @Override
    public String getBeforeState() {
        return "no row for " + this.issueId;
    }

    @Override
    public String getAfterState() {
        return this.issueId + " -> " + this.nextIssueId;
    }

    public Long getNextIssueId() {
        return this.nextIssueId;
    }
}

