/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInputParametersCheck;

public class InsertParametersCheck
extends BaseInputParametersCheck {
    private final Long newPrevious;
    private final Long newNext;

    public InsertParametersCheck(ActiveObjects ao, Long customFieldId, Long issueId, Long newPrevious, Long newNext) {
        super(ao, customFieldId, issueId);
        this.newPrevious = newPrevious;
        this.newNext = newNext;
    }

    @Override
    void additionalChecks() {
        if (InsertParametersCheck.compareLongValues(this.issueId, this.newPrevious) || InsertParametersCheck.compareLongValues(this.issueId, this.newNext)) {
            throw new RankDaoSanityCheckException(String.format("Sanity check for issue insertion parameters failed. IssueId must neither be newPrevious nor newNext", new Object[0]));
        }
    }

    @Override
    public String getBeforeState() {
        return "issue insertion parameters check";
    }

    public Long getNewPrevious() {
        return this.newPrevious;
    }

    public Long getNewNext() {
        return this.newNext;
    }
}

