/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank.instruction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.greenhopper.manager.rank.instruction.BaseInstruction;
import net.java.ao.Query;

public class DatabaseEmptinessCheck
extends BaseInstruction {
    public DatabaseEmptinessCheck(ActiveObjects ao, Long customFieldId, Long issueId) {
        super(ao, customFieldId, issueId);
    }

    @Override
    public void sanityCheck() {
        IssueRankingAO[] result = (IssueRankingAO[])this.ao.find(IssueRankingAO.class, Query.select().where("CUSTOM_FIELD_ID = ?", new Object[]{this.customFieldId}));
        if (result == null || result.length == 0) {
            return;
        }
        if (result.length == 1 && DatabaseEmptinessCheck.compareLongValues(result[0].getIssueId(), this.issueId) && DatabaseEmptinessCheck.compareLongValues(result[0].getNextId(), null)) {
            return;
        }
        throw new RankDaoSanityCheckException(String.format("Sanity check for index emptiness failed. There should not be any issues for custom field %d, found %d instead", this.customFieldId, result.length));
    }

    @Override
    public String getBeforeState() {
        return "empty index for custom field " + this.customFieldId;
    }
}

