/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.rank.IssueRankingAO;
import com.atlassian.greenhopper.manager.rank.IssueRankingOperationLogAO;
import com.atlassian.greenhopper.manager.rank.OperationInfo;
import com.atlassian.greenhopper.manager.rank.OperationInfoFactory;
import com.atlassian.greenhopper.manager.rank.RankDao;
import com.atlassian.greenhopper.manager.rank.RankDaoOperation;
import com.atlassian.greenhopper.manager.rank.RankDaoSanityCheckException;
import com.atlassian.jira.util.Consumer;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankDaoImpl
implements RankDao {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String SANITY_CHECK_PENDING = "no";
    private static final String SANITY_CHECK_PASSED = "yes";
    private static final Object lock = new Object();
    @Autowired
    private ActiveObjects ao;
    private OperationInfoFactory operationInfoFactory = new OperationInfoFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAll(Long customFieldId, final Consumer<IssueRankingAO> consumer) {
        Object object = lock;
        synchronized (object) {
            this.ensureNoOutstandingTransactions();
            this.ao.stream(IssueRankingAO.class, Query.select((String)"ID, ISSUE_ID, NEXT_ID").where("CUSTOM_FIELD_ID = ?", new Object[]{customFieldId}), (EntityStreamCallback)new EntityStreamCallback<IssueRankingAO, Long>(){

                public void onRowRead(IssueRankingAO t) {
                    consumer.consume((Object)t);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Long customFieldId, Long issueId, Long newNext, Long newPrevious) {
        Object object = lock;
        synchronized (object) {
            this.createTransaction(RankDaoOperation.INSERT, customFieldId, issueId, null, null, newNext, newPrevious);
            this.executeOutstandingTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Long customFieldId, Long issueId, Long oldNext, Long oldPrevious, Long newNext, Long newPrevious) {
        Object object = lock;
        synchronized (object) {
            this.createTransaction(RankDaoOperation.MOVE, customFieldId, issueId, oldNext, oldPrevious, newNext, newPrevious);
            this.executeOutstandingTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Long customFieldId, Long issueId, Long oldNext, Long oldPrevious) {
        Object object = lock;
        synchronized (object) {
            this.createTransaction(RankDaoOperation.REMOVE, customFieldId, issueId, oldNext, oldPrevious, null, null);
            this.executeOutstandingTransaction();
        }
    }

    private void createTransaction(RankDaoOperation operation, Long customFieldId, Long issueId, Long oldNext, Long oldPrevious, Long newNext, Long newPrevious) {
        this.log.debug("creating transaction %s for customField %d and issue %d: oldNext %d, oldPrevious %d, newNext %d, newPrevious %d", new Object[]{operation, customFieldId, issueId, oldNext, oldPrevious, newNext, newPrevious});
        if (this.ao.count(IssueRankingOperationLogAO.class) > 0) {
            throw new RuntimeException("Issue Ranking Operation log entry found where none expected. Please restart JIRA.");
        }
        this.ao.create(IssueRankingOperationLogAO.class, new DBParam[]{new DBParam("LOG_TYPE", (Object)operation.op), new DBParam("CUSTOM_FIELD_ID", (Object)customFieldId), new DBParam("ISSUE_ID", (Object)issueId), new DBParam("OLD_NEXT_ID", (Object)oldNext), new DBParam("OLD_PREVIOUS_ID", (Object)oldPrevious), new DBParam("NEW_NEXT_ID", (Object)newNext), new DBParam("NEW_PREVIOUS_ID", (Object)newPrevious), new DBParam("SANITY_CHECKED", (Object)SANITY_CHECK_PENDING)});
    }

    private void ensureNoOutstandingTransactions() {
    }

    void executeOutstandingTransaction() {
        IssueRankingOperationLogAO[] logs = (IssueRankingOperationLogAO[])this.ao.find(IssueRankingOperationLogAO.class);
        if (logs.length < 1) {
            return;
        }
        if (logs.length > 1) {
            throw new RuntimeException("More than one rank operation outstanding. Don't know how to handle, please fix up manually.");
        }
        IssueRankingOperationLogAO rankLog = logs[0];
        OperationInfo operation = this.operationInfoFactory.createOperationInfo(this.ao, rankLog);
        if (this.log.isDebugEnabled()) {
            this.log.debug(operation.toString(), new Object[0]);
        }
        try {
            operation.sanityCheck();
        }
        catch (RuntimeException e) {
            this.log.error(operation.toString(), new Object[0]);
            if (e instanceof RankDaoSanityCheckException) {
                this.log.error("Transaction sanity checked: %s", rankLog.getSanityChecked());
                if (SANITY_CHECK_PENDING.equals(rankLog.getSanityChecked())) {
                    this.log.error("Removing erroneous transaction record %d", rankLog.getId());
                    this.ao.delete(new RawEntity[]{rankLog});
                    this.ao.flushAll();
                } else {
                    this.log.error("Cannot manually remove erroneous transaction as it is unknown whether parts of the transaction have already been applied", new Object[0]);
                }
            }
            throw e;
        }
        rankLog.setSanityChecked(SANITY_CHECK_PASSED);
        rankLog.save();
        operation.execute();
        this.log.debug("deleting transaction record %d", rankLog.getId());
        this.ao.delete(new RawEntity[]{rankLog});
        this.ao.flushAll();
    }
}

