/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.manager.rank.IssueRankingOperationLogAO;
import com.atlassian.greenhopper.manager.rank.OperationInfo;
import com.atlassian.greenhopper.manager.rank.RankDaoOperation;
import com.atlassian.greenhopper.manager.rank.instruction.DatabaseEmptinessCheck;
import com.atlassian.greenhopper.manager.rank.instruction.InsertParametersCheck;
import com.atlassian.greenhopper.manager.rank.instruction.InsertRowInstruction;
import com.atlassian.greenhopper.manager.rank.instruction.Instruction;
import com.atlassian.greenhopper.manager.rank.instruction.LastRowCheck;
import com.atlassian.greenhopper.manager.rank.instruction.MoveParametersCheck;
import com.atlassian.greenhopper.manager.rank.instruction.RemoveParametersCheck;
import com.atlassian.greenhopper.manager.rank.instruction.RemoveRowInstruction;
import com.atlassian.greenhopper.manager.rank.instruction.TopOfChainCheck;
import com.atlassian.greenhopper.manager.rank.instruction.UpdateRowInstruction;

public class OperationInfoFactory {
    public OperationInfo createOperationInfo(ActiveObjects ao, IssueRankingOperationLogAO log) {
        Instruction[] instructions;
        RankDaoOperation op = RankDaoOperation.fromOp(log.getLogType());
        if (op == null) {
            throw new RuntimeException("Invalid rank operation found, don't know how to handle.");
        }
        switch (op) {
            case INSERT: {
                instructions = this.extractInsertInstructions(ao, log);
                break;
            }
            case MOVE: {
                instructions = this.extractMoveInstructions(ao, log);
                break;
            }
            case REMOVE: {
                instructions = this.extractRemoveInstructions(ao, log);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Operation " + (Object)((Object)op));
            }
        }
        return new OperationInfo(log, op, instructions);
    }

    private Instruction[] extractInsertInstructions(ActiveObjects ao, IssueRankingOperationLogAO log) {
        Long customFieldId = log.getCustomFieldId();
        Long issueId = log.getIssueId();
        Long newPrevious = log.getNewPreviousId();
        Long newNext = log.getNewNextId();
        InsertParametersCheck paramsCheck = new InsertParametersCheck(ao, customFieldId, issueId, newPrevious, newNext);
        if (newPrevious == null && newNext == null) {
            DatabaseEmptinessCheck emptinessCheck = new DatabaseEmptinessCheck(ao, customFieldId, issueId);
            InsertRowInstruction create = new InsertRowInstruction(ao, customFieldId, issueId, null);
            return new Instruction[]{paramsCheck, emptinessCheck, create};
        }
        if (newPrevious == null) {
            TopOfChainCheck topCheck = new TopOfChainCheck(ao, customFieldId, newNext, issueId);
            InsertRowInstruction create = new InsertRowInstruction(ao, customFieldId, issueId, newNext);
            return new Instruction[]{paramsCheck, topCheck, create};
        }
        UpdateRowInstruction update = new UpdateRowInstruction(ao, customFieldId, newPrevious, newNext, issueId);
        InsertRowInstruction create = new InsertRowInstruction(ao, customFieldId, issueId, newNext);
        return new Instruction[]{paramsCheck, update, create};
    }

    private Instruction[] extractMoveInstructions(ActiveObjects ao, IssueRankingOperationLogAO log) {
        Long customFieldId = log.getCustomFieldId();
        Long issueId = log.getIssueId();
        Long oldPrevious = log.getOldPreviousId();
        Long oldNext = log.getOldNextId();
        Long newPrevious = log.getNewPreviousId();
        Long newNext = log.getNewNextId();
        MoveParametersCheck paramsCheck = new MoveParametersCheck(ao, customFieldId, issueId, oldPrevious, oldNext, newPrevious, newNext);
        if (newPrevious == null) {
            TopOfChainCheck oldHeadCheck = new TopOfChainCheck(ao, customFieldId, newNext, issueId);
            TopOfChainCheck newHeadCheck = new TopOfChainCheck(ao, customFieldId, issueId, oldPrevious);
            UpdateRowInstruction first = new UpdateRowInstruction(ao, customFieldId, oldPrevious, issueId, oldNext);
            UpdateRowInstruction second = new UpdateRowInstruction(ao, customFieldId, issueId, oldNext, newNext);
            return new Instruction[]{paramsCheck, oldHeadCheck, newHeadCheck, first, second};
        }
        if (oldPrevious == null) {
            TopOfChainCheck oldHeadCheck = new TopOfChainCheck(ao, customFieldId, issueId, newPrevious);
            TopOfChainCheck newHeadCheck = new TopOfChainCheck(ao, customFieldId, oldNext, issueId);
            UpdateRowInstruction first = new UpdateRowInstruction(ao, customFieldId, newPrevious, newNext, issueId);
            UpdateRowInstruction second = new UpdateRowInstruction(ao, customFieldId, issueId, oldNext, newNext);
            return new Instruction[]{paramsCheck, oldHeadCheck, newHeadCheck, first, second};
        }
        UpdateRowInstruction first = new UpdateRowInstruction(ao, customFieldId, oldPrevious, issueId, oldNext);
        UpdateRowInstruction second = new UpdateRowInstruction(ao, customFieldId, newPrevious, newNext, issueId);
        UpdateRowInstruction third = new UpdateRowInstruction(ao, customFieldId, issueId, oldNext, newNext);
        return new Instruction[]{paramsCheck, first, second, third};
    }

    private Instruction[] extractRemoveInstructions(ActiveObjects ao, IssueRankingOperationLogAO log) {
        Long customFieldId = log.getCustomFieldId();
        Long issueId = log.getIssueId();
        Long oldPrevious = log.getOldPreviousId();
        Long oldNext = log.getOldNextId();
        RemoveParametersCheck paramCheck = new RemoveParametersCheck(ao, customFieldId, issueId, oldPrevious, oldNext);
        if (oldPrevious == null && oldNext == null) {
            LastRowCheck lastCheck = new LastRowCheck(ao, customFieldId, issueId);
            RemoveRowInstruction delete = new RemoveRowInstruction(ao, customFieldId, issueId, null);
            return new Instruction[]{paramCheck, lastCheck, delete};
        }
        if (oldPrevious == null) {
            TopOfChainCheck oldHeadCheck = new TopOfChainCheck(ao, customFieldId, issueId, null);
            TopOfChainCheck newHeadCheck = new TopOfChainCheck(ao, customFieldId, oldNext, issueId);
            RemoveRowInstruction delete = new RemoveRowInstruction(ao, customFieldId, issueId, oldNext);
            return new Instruction[]{paramCheck, oldHeadCheck, newHeadCheck, delete};
        }
        UpdateRowInstruction update = new UpdateRowInstruction(ao, customFieldId, oldPrevious, issueId, oldNext);
        RemoveRowInstruction delete = new RemoveRowInstruction(ao, customFieldId, issueId, oldNext);
        return new Instruction[]{paramCheck, update, delete};
    }
}

