/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.rank;

import com.atlassian.greenhopper.manager.rank.IssueRankingOperationLogAO;
import com.atlassian.greenhopper.manager.rank.RankDaoOperation;
import com.atlassian.greenhopper.manager.rank.instruction.Instruction;

public class OperationInfo {
    final IssueRankingOperationLogAO log;
    final RankDaoOperation op;
    final Instruction[] instructions;

    OperationInfo(IssueRankingOperationLogAO log, RankDaoOperation op, Instruction[] instructions) {
        this.log = log;
        this.op = op;
        this.instructions = instructions;
    }

    void sanityCheck() {
        for (Instruction instruction : this.instructions) {
            instruction.sanityCheck();
        }
    }

    void execute() {
        for (Instruction instruction : this.instructions) {
            instruction.execute();
        }
    }

    public String toString() {
        int x;
        StringBuilder builder = new StringBuilder();
        builder.append(this.op.toString()).append(" transaction").append(" (logId=").append(this.log.getId()).append(", cfId=").append(this.log.getCustomFieldId()).append("):  ");
        builder.append("before [");
        for (x = 0; x < this.instructions.length; ++x) {
            if (x > 0) {
                builder.append(", ");
            }
            builder.append(this.instructions[x].getBeforeState());
        }
        builder.append("]   after [");
        for (x = 0; x < this.instructions.length; ++x) {
            if (x > 0) {
                builder.append(", ");
            }
            builder.append(this.instructions[x].getAfterState());
        }
        builder.append("]");
        return builder.toString();
    }
}

