/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.properties;

import com.atlassian.greenhopper.manager.properties.ManagedIssueTypePropertyDao;
import com.atlassian.greenhopper.service.PersistenceService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagedIssueTypePropertyDaoImpl
implements ManagedIssueTypePropertyDao {
    private static final String EPIC_ISSUE_TYPE_OLD_PROPERTY_KEY = "gh.issue.epic";
    private static final String EPIC_ISSUE_TYPE_NEW_PROPERTY_KEY = "GreenHopper.Epic.Default.issuetype.id";
    private static final String STORY_ISSUE_TYPE_OLD_PROPERTY_KEY = "gh.issue.story";
    private static final String STORY_ISSUE_TYPE_NEW_PROPERTY_KEY = "GreenHopper.Story.Default.issuetype.id";
    private static final String GREENHOPPER_ENTITY_NAME = "GreenHopper";
    private static final long GREENHOPPER_ENTITY_ID = 1L;
    private static final String SCRUM_CONFIGURATION_PROPERTY_KEY = "SCRUM_DEFAULT_TEMPLATE_CONFIGURATION";
    @Autowired
    private PersistenceService persistenceService;
    @Autowired
    private PropertyDao propertyDao;

    @Override
    public String getEpicProperty() {
        return this.getStoredProperty(EPIC_ISSUE_TYPE_OLD_PROPERTY_KEY, EPIC_ISSUE_TYPE_NEW_PROPERTY_KEY);
    }

    @Override
    public void setEpicProperty(String value) {
        this.setStoredProperty(EPIC_ISSUE_TYPE_NEW_PROPERTY_KEY, value);
    }

    @Override
    public String getStoryProperty() {
        return this.getStoredProperty(STORY_ISSUE_TYPE_OLD_PROPERTY_KEY, STORY_ISSUE_TYPE_NEW_PROPERTY_KEY);
    }

    @Override
    public void setStoryProperty(String value) {
        this.setStoredProperty(STORY_ISSUE_TYPE_NEW_PROPERTY_KEY, value);
    }

    @VisibleForTesting
    String getStoredProperty(String oldKey, String newKey) {
        String value = this.propertyDao.getStringProperty(newKey);
        if (value != null) {
            return value;
        }
        value = this.getOldPropertyValue(oldKey);
        if (value == null) {
            return null;
        }
        return this.storePropertyInMigratedStoreIfNotSet(newKey, value);
    }

    private String getOldPropertyValue(String oldKey) {
        Map<String, Object> propertyMap = this.getScrumDefaultConfigurationData();
        if (propertyMap == null) {
            return null;
        }
        String value = (String)propertyMap.get(oldKey);
        if (value == null) {
            return null;
        }
        return value;
    }

    Map<String, Object> getScrumDefaultConfigurationData() {
        return this.persistenceService.getData(GREENHOPPER_ENTITY_NAME, 1L, SCRUM_CONFIGURATION_PROPERTY_KEY);
    }

    private synchronized String storePropertyInMigratedStoreIfNotSet(String newKey, String value) {
        String newValue = this.propertyDao.getStringProperty(newKey);
        if (newValue != null) {
            return newValue;
        }
        this.setStoredProperty(newKey, value);
        return value;
    }

    private void setStoredProperty(String newPropertyKey, String value) {
        this.propertyDao.setStringProperty(newPropertyKey, value);
    }
}

