/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.properties;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.properties.ManagedFieldPropertyDao;
import com.atlassian.greenhopper.service.PersistenceService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagedFieldPropertyDaoImpl
implements ManagedFieldPropertyDao {
    private static final String STORY_POINTS_FIELD_OLD_PROPERTY_KEY = "gh.issue.storypoints";
    private static final String STORY_POINTS_FIELD_NEW_PROPERTY_KEY = "GreenHopper.StoryPoints.Default.customfield.id";
    private static final String FLAG_FIELD_OLD_PROPERTY_KEY = "gh.issue.flaggingfield";
    private static final String FLAG_FIELD_NEW_PROPERTY_KEY = "GreenHopper.Flag.Default.customfield.id";
    private static final String BUSINESS_VALUE_FIELD_OLD_PROPERTY_KEY = "gh.issue.businessvalues";
    private static final String BUSINESS_VALUE_FIELD_NEW_PROPERTY_KEY = "GreenHopper.BusinessValue.Default.customfield.id";
    private static final String CLASSIC_EPIC_LABEL_FIELD_OLD_PROPERTY_KEY = "gh.issue.labelfield";
    private static final String CLASSIC_EPIC_LABEL_FIELD_NEW_PROPERTY_KEY = "GreenHopper.ClassicEpicLabel.Default.customfield.id";
    private static final String GREENHOPPER_ENTITY_NAME = "GreenHopper";
    private static final long GREENHOPPER_ENTITY_ID = 1L;
    private static final String SCRUM_CONFIGURATION_PROPERTY_KEY = "SCRUM_DEFAULT_TEMPLATE_CONFIGURATION";
    private final LoggerWrapper log = LoggerWrapper.with(ManagedFieldPropertyDaoImpl.class);
    @Autowired
    private PersistenceService persistenceService;
    @Autowired
    private PropertyDao propertyDao;

    @Override
    public Long getStoryPointsProperty() {
        return this.getStoredProperty(STORY_POINTS_FIELD_OLD_PROPERTY_KEY, STORY_POINTS_FIELD_NEW_PROPERTY_KEY);
    }

    @Override
    public synchronized void setStoryPointsProperty(Long value) {
        this.setStoredProperty(STORY_POINTS_FIELD_NEW_PROPERTY_KEY, value);
    }

    @Override
    public Long getFlagProperty() {
        return this.getStoredProperty(FLAG_FIELD_OLD_PROPERTY_KEY, FLAG_FIELD_NEW_PROPERTY_KEY);
    }

    @Override
    public void setFlagProperty(Long value) {
        this.setStoredProperty(FLAG_FIELD_NEW_PROPERTY_KEY, value);
    }

    @Override
    public Long getBusinessValueProperty() {
        return this.getStoredProperty(BUSINESS_VALUE_FIELD_OLD_PROPERTY_KEY, BUSINESS_VALUE_FIELD_NEW_PROPERTY_KEY);
    }

    @Override
    public void setBusinessValueProperty(Long value) {
        this.setStoredProperty(BUSINESS_VALUE_FIELD_NEW_PROPERTY_KEY, value);
    }

    @Override
    public Long getClassicEpicLabelProperty() {
        return this.getStoredProperty(CLASSIC_EPIC_LABEL_FIELD_OLD_PROPERTY_KEY, CLASSIC_EPIC_LABEL_FIELD_NEW_PROPERTY_KEY);
    }

    @Override
    public void setClassicEpicLabelProperty(Long value) {
        this.setStoredProperty(CLASSIC_EPIC_LABEL_FIELD_NEW_PROPERTY_KEY, value);
    }

    @VisibleForTesting
    Long getStoredProperty(String oldKey, String newKey) {
        Long longValueOfId = this.propertyDao.getLongProperty(newKey);
        if (longValueOfId != null) {
            return longValueOfId;
        }
        String value = this.getOldPropertyValue(oldKey);
        if (value == null) {
            return null;
        }
        try {
            longValueOfId = CustomFieldUtils.getCustomFieldId((String)value);
        }
        catch (NumberFormatException e) {
            this.log.info("Stored property for key '%s' was an invalid custom field identifier; returning null", oldKey);
            return null;
        }
        return this.storePropertyInMigratedStoreIfNotSet(newKey, longValueOfId);
    }

    private String getOldPropertyValue(String oldKey) {
        Map<String, Object> propertyMap = this.getScrumDefaultConfigurationData();
        if (propertyMap == null) {
            return null;
        }
        String value = (String)propertyMap.get(oldKey);
        if (value == null) {
            return null;
        }
        return value;
    }

    private Map<String, Object> getScrumDefaultConfigurationData() {
        return this.persistenceService.getData(GREENHOPPER_ENTITY_NAME, 1L, SCRUM_CONFIGURATION_PROPERTY_KEY);
    }

    private synchronized Long storePropertyInMigratedStoreIfNotSet(String newKey, Long value) {
        Long id = this.propertyDao.getLongProperty(newKey);
        if (id != null) {
            return id;
        }
        this.setStoredProperty(newKey, value);
        return value;
    }

    private void setStoredProperty(String newPropertyKey, Long value) {
        this.propertyDao.setLongProperty(newPropertyKey, value);
    }
}

