/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank.suspend;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.suspend.LexoRankSuspendManager;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankSuspendManagerImpl
implements LexoRankSuspendManager {
    private final LoggerWrapper log = LoggerWrapper.with(LexoRankSuspendManagerImpl.class);
    private static final String LEXORANK_SUSPEND_PROPERTY_SET = LexoRankSuspendManagerImpl.class + ".lexoRankSuspendPropertySet";
    private static final String PROPERTY_KEY_LEXORANK_SUSPENDED = "com.atlassian.greenhopper.lexorank:lexorank.suspended";
    @Autowired
    private JiraPropertySetFactory jiraPropertySetFactory;
    private PropertySet lexoRankSuspendProperties;

    @PostConstruct
    public void init() {
        this.lexoRankSuspendProperties = this.jiraPropertySetFactory.buildNoncachingPropertySet(LEXORANK_SUSPEND_PROPERTY_SET);
    }

    @Override
    public ServiceOutcome<Boolean> suspendLexoRankBalancing() {
        this.log.info("Suspending LexoRank rebalancing...", new Object[0]);
        return ServiceOutcomeImpl.ok(this.set(true));
    }

    @Override
    public ServiceOutcome<Boolean> resumeLexoRankBalancing() {
        this.log.info("Resuming LexoRank rebalancing...", new Object[0]);
        return ServiceOutcomeImpl.ok(this.set(false));
    }

    @Override
    public boolean isSuspended() {
        return this.get();
    }

    private boolean set(boolean isBalancingSuspended) {
        this.lexoRankSuspendProperties.setBoolean(PROPERTY_KEY_LEXORANK_SUSPENDED, isBalancingSuspended);
        return isBalancingSuspended;
    }

    private boolean get() {
        return this.lexoRankSuspendProperties.getBoolean(PROPERTY_KEY_LEXORANK_SUSPENDED);
    }
}

