/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank.lock;

import com.atlassian.greenhopper.manager.lexorank.lock.Lock;

public class LockOutcome {
    private Lock lock;
    private boolean valid;
    private FailReason failReason;
    private String failMessage;

    private LockOutcome(Lock lock) {
        this.valid = true;
        this.lock = lock;
    }

    private LockOutcome(FailReason failReason, String failMessage) {
        this.valid = false;
        this.failReason = failReason;
        this.failMessage = failMessage;
    }

    private LockOutcome(Lock lock, FailReason failReason, String failMessage) {
        this.valid = false;
        this.lock = lock;
        this.failReason = failReason;
        this.failMessage = failMessage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public Lock get() {
        return this.lock;
    }

    public FailReason getFailReason() {
        return this.failReason;
    }

    public String getFailDetails() {
        return this.failMessage;
    }

    public boolean isFailRetry() {
        return this.getFailReason().retry;
    }

    public static LockOutcome lock(Lock lock) {
        return new LockOutcome(lock);
    }

    public static LockOutcome fail(FailReason reason, String message, Object ... params) {
        return new LockOutcome(reason, LockOutcome.createMessage(message, params));
    }

    public static LockOutcome failButWithLock(Lock lock, FailReason reason, String message, Object ... params) {
        return new LockOutcome(lock, reason, LockOutcome.createMessage(message, params));
    }

    private static String createMessage(String message, Object[] params) {
        try {
            return String.format(message, params);
        }
        catch (RuntimeException e) {
            return "Unable to format message: " + message;
        }
    }

    public static enum FailReason {
        SQL_EXCEPTION(false),
        NO_RECORDS(false),
        NEEDS_RETRY(true);

        private final boolean retry;

        private FailReason(boolean retry) {
            this.retry = retry;
        }
    }
}

