/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank.collation;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDaoContext;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.SqlDeleteStatement;
import com.atlassian.greenhopper.manager.lexorank.SqlSelectStatement;
import com.atlassian.greenhopper.manager.lexorank.SqlSortOrder;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.jira.exception.DataAccessException;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.Common;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollationIntegrityDao {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    protected ActiveObjects ao;

    public LexoRankAO[] createCollationCheckRows(long fieldId, long issueId, String[] ranks) {
        LexoRankAO[] aos = new LexoRankAO[ranks.length];
        for (int i = 0; i < ranks.length; ++i) {
            LexoRankAO lexoRankAO;
            LexoRankBucket rankBucket = LexoRankBucket.fromRank(ranks[i]);
            aos[i] = lexoRankAO = (LexoRankAO)this.ao.create(LexoRankAO.class, new DBParam[]{new DBParam("FIELD_ID", (Object)fieldId), new DBParam("ISSUE_ID", (Object)issueId), new DBParam("TYPE", (Object)LexoRankRow.RankRowType.COLLATION_CHECK_ROW.getId()), new DBParam("RANK", (Object)ranks[i]), new DBParam("LOCK_TIME", (Object)System.currentTimeMillis()), new DBParam("BUCKET", (Object)rankBucket.intValue())});
        }
        return aos;
    }

    public List<LexoRankRow> findCollationCheckRows(LexoRankDaoContext ctx, long fieldId, long issueId, int limit) {
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        String typeColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.TYPE);
        String issueIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + typeColumnName + " = ? AND " + issueIdColumnName + " = ?", fieldId, LexoRankRow.RankRowType.COLLATION_CHECK_ROW.getId(), issueId).orderBy(rankColumnName, SqlSortOrder.ASC).limit(limit).build();
        this.log.debug(" Checking collation of DB : %s", selectStatement.toSql());
        ResultSet resultSet = null;
        try {
            resultSet = selectStatement.execute();
            ArrayList lexoRankList = Lists.newArrayList();
            while (resultSet.next()) {
                LexoRankRow lexoRankRow = LexoRankRow.builder().id(resultSet.getLong(LexoRankAO.ColumnDetails.ID.getNaturalOrderIndex())).forRankField(resultSet.getLong(LexoRankAO.ColumnDetails.FIELD_ID.getNaturalOrderIndex())).forIssue(resultSet.getLong(LexoRankAO.ColumnDetails.ISSUE_ID.getNaturalOrderIndex())).withRank(resultSet.getString(LexoRankAO.ColumnDetails.RANK.getNaturalOrderIndex())).ofType(resultSet.getInt(LexoRankAO.ColumnDetails.TYPE.getNaturalOrderIndex())).withLock(resultSet.getString(LexoRankAO.ColumnDetails.LOCK_HASH.getNaturalOrderIndex()), resultSet.getLong(LexoRankAO.ColumnDetails.LOCK_TIME.getNaturalOrderIndex())).build();
                lexoRankList.add(lexoRankRow);
            }
            ArrayList arrayList = lexoRankList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            selectStatement.close();
        }
    }

    public void deleteCollationCheckRows(LexoRankDaoContext ctx, LexoRankAO[] aos, long timestamp) {
        if (aos != null && aos.length > 0) {
            try {
                this.ao.delete((RawEntity[])aos);
            }
            catch (Exception e) {
                this.log.error(" Unable to delete rows from LexoRank Table, if this problem persist it could slow down Jira startup", e);
            }
        }
        try {
            String rowType = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.TYPE);
            String lockTime = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
            SqlDeleteStatement sqlDeleteStatement = SqlDeleteStatement.builder(ctx.getEntityDetails()).where(rowType + " = ? AND " + lockTime + " < ?", LexoRankRow.RankRowType.COLLATION_CHECK_ROW.getId(), timestamp).build();
            this.log.debug(" Deleting old rows : %s ", sqlDeleteStatement.toSql());
            int rowsDeleted = sqlDeleteStatement.execute();
            if (rowsDeleted > 0) {
                this.log.debug(" Delete old rows from DB : %d ", rowsDeleted);
            }
        }
        catch (Exception e) {
            this.log.error(" Exception occured while trying to delete all rows. Skipping ... ", e);
        }
    }
}

