/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank.collation;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDaoContext;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.collation.CollationIntegrityChecker;
import com.atlassian.greenhopper.manager.lexorank.collation.CollationIntegrityDao;
import com.atlassian.greenhopper.web.util.GreenHopperHelpPathResolver;
import com.atlassian.jira.config.properties.JiraProperties;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.java.ao.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollationIntegrityCheckerImpl
implements CollationIntegrityChecker {
    public static final String COLLATION_DISABLE = "greenhopper.force.collation.functions.never";
    public static final String FORCE_COLLATION = "greenhopper.force.collation.functions.always";
    private static final LoggerWrapper log = LoggerWrapper.with(CollationIntegrityCheckerImpl.class);
    private static final int DELETE_OLD_ROWS_TIME_IN_MINUTES = 5;
    static final String[] RANKS = new String[]{"0|0tto", "0|1tto", "0|aa", "0|ot1o", "0|otto", "0|z"};
    @Autowired
    private JiraProperties jiraProperties;
    @Autowired
    private GreenHopperHelpPathResolver helpPathResolver;
    @Autowired
    private CollationIntegrityDao collationIntegrityDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LexoRankDaoContext getLexoRankDaoContext() {
        long fakeFieldId = -9223372036854775807L;
        long fakeIssueId = -9223372036854775806L;
        LexoRankAO[] ranks = this.collationIntegrityDao.createCollationCheckRows(-9223372036854775807L, -9223372036854775806L, RANKS);
        EntityManager entityManager = ranks[0].getEntityManager();
        LexoRankDaoContext ctx = new LexoRankDaoContext(entityManager, false);
        try {
            if (this.isForceCollationEnable()) {
                log.warn("Forcing collation queries for JIRA Agile.", new Object[0]);
            } else if (this.isCollationDisabled()) {
                log.warn("Collation check is disable for JIRA Agile.", new Object[0]);
                ctx = new LexoRankDaoContext(entityManager, true);
            } else {
                List<LexoRankRow> lexoRankRows = this.collationIntegrityDao.findCollationCheckRows(ctx, -9223372036854775807L, -9223372036854775806L, RANKS.length);
                if (lexoRankRows.size() == 0) {
                    log.error(" Tried to check the collation building a table and ordering but failed", new Object[0]);
                    LexoRankDaoContext lexoRankDaoContext = ctx;
                    return lexoRankDaoContext;
                }
                ctx = new LexoRankDaoContext(entityManager, this.checkOrdering(lexoRankRows));
            }
        }
        catch (Exception e) {
            log.error(" We got an exception trying to understand the collation of the DB. Skipping...", new Object[0]);
            log.exception(e);
        }
        finally {
            long timestamp = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
            this.collationIntegrityDao.deleteCollationCheckRows(ctx, ranks, timestamp);
        }
        return ctx;
    }

    private boolean isCollationDisabled() {
        return this.jiraProperties.getBoolean(COLLATION_DISABLE);
    }

    private boolean isForceCollationEnable() {
        return this.jiraProperties.getBoolean(FORCE_COLLATION);
    }

    private boolean checkOrdering(List<LexoRankRow> lexoRankRows) {
        log.debug(" Checking collation by ordering %d rows", RANKS.length);
        log.debug(" Ranks %s", Arrays.asList(RANKS));
        log.debug(" Ranks in DB %s", lexoRankRows.toString());
        if (RANKS.length != lexoRankRows.size()) {
            log.warn(" Size of test ranks [%d] and DB [%d] did not match, something went wrong. Skipping.", RANKS.length, lexoRankRows.size());
            return false;
        }
        for (int i = 0; i < lexoRankRows.size(); ++i) {
            LexoRankRow ci = lexoRankRows.get(i);
            if (RANKS[i].equals(ci.getRank())) continue;
            this.printWarning();
            return false;
        }
        log.info(" Collation check performed against LexoRank table: OK", new Object[0]);
        return true;
    }

    private void printWarning() {
        log.warn("****************************************************************************************************", new Object[0]);
        log.warn(" The database collation is set incorrectly for JIRA Agile. This can cause JIRA Agile to run slower. ", new Object[0]);
        log.warn(" If you are using PostgreSQL 9.0 or earlier, this may also cause ranking to fail.", new Object[0]);
        log.warn(" Please refer to the following documentation on the database configuration: " + this.helpPathResolver.getHelpPath("external.db.configuration").getUrl(), new Object[0]);
        log.warn(" If the problems persist, please refer to this KB on how to fix the database: " + this.helpPathResolver.getHelpPath("external.db.collation.fix").getUrl(), new Object[0]);
        log.warn("****************************************************************************************************", new Object[0]);
    }
}

