/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank.balancer;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntry;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryAO;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryAOMapper;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryDao;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryManager;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BalancerEntryManagerImpl
implements BalancerEntryManager {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    BalancerEntryDao balancerEntryDao;
    @Autowired
    BalancerEntryAOMapper balancerEntryAOMapper;
    @Autowired
    LexoRankStatisticsAgent lexoRankStatisticsAgent;

    @Override
    public void delete(BalancerEntry entry) {
        this.lexoRankStatisticsAgent.startOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_DELETE);
        this.log.debug("BalancerEntryManagerImpl.delete entry=" + entry, new Object[0]);
        BalancerEntryAO entryAO = this.balancerEntryDao.get(entry.getFieldId());
        this.log.debug("BalancerEntryManagerImpl.delete entryAO=" + entryAO, new Object[0]);
        if (entryAO != null) {
            this.log.debug("BalancerEntryManagerImpl.delete balanceEntryDao.delete", new Object[0]);
            this.balancerEntryDao.delete(new BalancerEntryAO[]{entryAO});
        }
        this.lexoRankStatisticsAgent.endOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_DELETE);
    }

    @Override
    public Long save(BalancerEntry entry) {
        this.lexoRankStatisticsAgent.startOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_SAVE);
        this.log.debug("BalancerEntryManagerImpl save entry=" + entry, new Object[0]);
        BalancerEntryAO entryAO = this.balancerEntryDao.get(entry.getFieldId());
        if (entryAO == null) {
            this.log.debug("BalancerEntryManagerImpl creating new entry", new Object[0]);
            entryAO = (BalancerEntryAO)this.balancerEntryDao.create(this.balancerEntryAOMapper.toAO(entry));
        } else {
            this.log.debug("BalancerEntryManagerImpl updating entry", new Object[0]);
            Long fieldId = entry.getFieldId();
            BalancerEntry.Builder builder = new BalancerEntry.Builder(entry.getFieldId());
            builder.rebalanceTime(new DateTime(Math.min(entry.getRebalanceTime().getMillis(), entryAO.getRebalanceTime())));
            builder.disableRankOperations(entry.rankingOperationsDisabled() || entryAO.getDisableRankOperations() != false);
            this.balancerEntryAOMapper.update(builder.build(), entryAO);
        }
        this.lexoRankStatisticsAgent.endOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_SAVE);
        return entryAO.getId();
    }

    @Override
    public List<BalancerEntry> list() {
        this.lexoRankStatisticsAgent.startOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_LIST);
        BalancerEntryAO[] entryAOs = this.balancerEntryDao.list();
        ArrayList entries = Lists.newArrayList();
        for (BalancerEntryAO ao : entryAOs) {
            entries.add(this.balancerEntryAOMapper.toModel(ao));
        }
        this.lexoRankStatisticsAgent.endOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_LIST);
        return entries;
    }

    @Override
    public BalancerEntry get(Long fieldId) {
        this.lexoRankStatisticsAgent.startOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_GET);
        BalancerEntry entry = null;
        BalancerEntryAO entryAO = this.balancerEntryDao.get(fieldId);
        if (entryAO != null) {
            entry = this.balancerEntryAOMapper.toModel(entryAO);
        }
        this.lexoRankStatisticsAgent.endOperation(LexoRankStatisticsAgent.Operation.BALANCER_ENTRY_GET);
        return entry;
    }
}

