/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank.balancer;

import com.atlassian.greenhopper.manager.AbstractAOMapper;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntry;
import com.atlassian.greenhopper.manager.lexorank.balancer.BalancerEntryAO;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class BalancerEntryAOMapper
extends AbstractAOMapper<BalancerEntryAO, BalancerEntry> {
    @Override
    @Nonnull
    public Map<String, Object> toAO(BalancerEntry model) {
        HashMap map = Maps.newHashMap();
        map.put("FIELD_ID", model.getFieldId());
        map.put("REBALANCE_TIME", model.getRebalanceTime().getMillis());
        map.put("DISABLE_RANK_OPERATIONS", model.rankingOperationsDisabled());
        return map;
    }

    @Override
    @Nonnull
    public BalancerEntry toModel(BalancerEntryAO record) {
        return new BalancerEntry.Builder(record.getFieldId()).rebalanceTime(new DateTime((Object)record.getRebalanceTime())).disableRankOperations(record.getDisableRankOperations()).build();
    }

    @Override
    public void update(BalancerEntry source, BalancerEntryAO target) {
        if (!source.getFieldId().equals(target.getFieldId())) {
            throw new IllegalArgumentException("source and target fieldIDs must match");
        }
        target.setRebalanceTime(source.getRebalanceTime().getMillis());
        target.setDisableRankOperations(source.rankingOperationsDisabled());
        target.save();
    }
}

