/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank.balancer;

import com.atlassian.greenhopper.model.rapid.AbstractModel;
import org.joda.time.DateTime;

public class BalancerEntry
extends AbstractModel {
    private Long fieldId;
    private DateTime rebalanceTime;
    private boolean disableRankOperations;

    private BalancerEntry(Long fieldId, DateTime rebalanceTime, boolean freezeRankOperations) {
        super(fieldId);
        this.fieldId = fieldId;
        this.rebalanceTime = rebalanceTime;
        this.disableRankOperations = freezeRankOperations;
    }

    public Long getFieldId() {
        return this.fieldId;
    }

    public DateTime getRebalanceTime() {
        return this.rebalanceTime;
    }

    public boolean rankingOperationsDisabled() {
        return this.disableRankOperations;
    }

    public static class Builder {
        private final Long fieldId;
        private DateTime rebalanceTime = DateTime.now();
        private boolean disableRankOperations = false;

        public Builder(Long fieldId) {
            this.fieldId = fieldId;
        }

        public Builder rebalanceTime(DateTime rebalanceTime) {
            this.rebalanceTime = rebalanceTime;
            return this;
        }

        public Builder rebalanceTimeNow() {
            this.rebalanceTime = DateTime.now();
            return this;
        }

        public Builder disableRankOperations(boolean disable) {
            this.disableRankOperations = disable;
            return this;
        }

        public Builder disableRankOperations() {
            this.disableRankOperations = true;
            return this;
        }

        public BalancerEntry build() {
            return new BalancerEntry(this.fieldId, this.rebalanceTime, this.disableRankOperations);
        }
    }
}

