/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityFieldUtils;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class SqlUpdateStatement {
    private static final int INFINITE_TIMEOUT = 0;
    private LexoRankEntityDetails entityDetails;
    private String sql;
    private List<ParamValueTypePair> params;

    private SqlUpdateStatement(LexoRankEntityDetails entityDetails, String sql, List<ParamValueTypePair> params) {
        this.entityDetails = entityDetails;
        this.sql = sql;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeWithTimeout(int timeoutInSeconds) throws SQLException {
        try (Connection connection = this.entityDetails.getConnection();){
            int n;
            PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
            try {
                int parameterIndex = 1;
                for (ParamValueTypePair param : this.params) {
                    Object paramValue = param.getValue();
                    Integer paramType = param.getType();
                    if (paramValue == null) {
                        preparedStatement.setNull(parameterIndex, paramType);
                    } else {
                        LexoRankEntityFieldUtils.setValue(preparedStatement, parameterIndex, paramValue);
                    }
                    ++parameterIndex;
                }
                preparedStatement.setQueryTimeout(timeoutInSeconds);
                n = preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                preparedStatement.close();
                throw throwable;
            }
            preparedStatement.close();
            return n;
        }
    }

    public int execute() throws SQLException {
        return this.executeWithTimeout(0);
    }

    public String getSql() {
        return this.sql;
    }

    public static SetClause builder(LexoRankEntityDetails entityDetails) {
        return new Builder(entityDetails);
    }

    public static class ParamValueTypePair {
        private Object value;
        private Integer type;

        public ParamValueTypePair(Object value, Integer type) {
            this.value = value;
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public Integer getType() {
            return this.type;
        }
    }

    public static interface CompleteStatement {
        public SqlUpdateStatement build();
    }

    public static interface WhereClause {
        public CompleteStatement where(String var1, Object ... var2);
    }

    public static interface SetClauseParameterSetter
    extends WhereClause {
        public SetClauseParameterSetter withParam(Object var1, Integer var2);

        public SetClauseParameterSetter withParam(Object var1);
    }

    public static interface SetClause {
        public SetClauseParameterSetter set(String var1);
    }

    private static class Builder
    implements SetClause,
    SetClauseParameterSetter,
    WhereClause,
    CompleteStatement {
        private LexoRankEntityDetails entityDetails;
        private String setClause;
        private String whereClause;
        private List<ParamValueTypePair> paramsValueAndTypePairs = Lists.newArrayList();

        private Builder(LexoRankEntityDetails entityDetails) {
            this.entityDetails = entityDetails;
        }

        @Override
        public SqlUpdateStatement build() {
            StringBuilder sql = new StringBuilder();
            String escapedWhereClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.whereClause);
            sql.append("UPDATE ").append(this.entityDetails.getTableName()).append(" SET ").append(this.setClause).append(" WHERE ").append(escapedWhereClause);
            return new SqlUpdateStatement(this.entityDetails, sql.toString(), this.paramsValueAndTypePairs);
        }

        @Override
        public SetClauseParameterSetter set(String setClause) {
            this.setClause = setClause;
            return this;
        }

        @Override
        public SetClauseParameterSetter withParam(Object value) {
            Integer type = null;
            if (value instanceof String) {
                type = 12;
            } else if (value instanceof Number) {
                type = -5;
            } else if (value instanceof Boolean) {
                type = 16;
            } else {
                throw new IllegalArgumentException("Parameter type " + value.getClass() + " is not supported. Only instances of String, Number and Boolean are supported");
            }
            this.paramsValueAndTypePairs.add(new ParamValueTypePair(value, type));
            return this;
        }

        @Override
        public SetClauseParameterSetter withParam(Object value, Integer type) {
            switch (type) {
                case -5: 
                case 4: 
                case 12: 
                case 16: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Given database type is not supported. Only VARCHAR, BIGINT and BOOLEAN are supported");
                }
            }
            this.paramsValueAndTypePairs.add(new ParamValueTypePair(value, type));
            return this;
        }

        @Override
        public CompleteStatement where(String whereClause, Object ... params) {
            this.whereClause = whereClause;
            for (Object param : params) {
                this.paramsValueAndTypePairs.add(new ParamValueTypePair(param, 12));
            }
            return this;
        }
    }
}

