/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityFieldUtils;
import com.atlassian.greenhopper.manager.lexorank.SqlExplicitSortLanguageFunction;
import com.atlassian.greenhopper.manager.lexorank.SqlSortLanguage;
import com.atlassian.greenhopper.manager.lexorank.SqlSortOrder;
import com.atlassian.greenhopper.util.database.DatabaseType;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.java.ao.Common;

public class SqlSelectStatement {
    private LexoRankEntityDetails entityDetails;
    private String sql;
    private List<Object> params = Lists.newArrayList();
    private PreparedStatement preparedStatement;
    private Connection connection = null;

    private SqlSelectStatement(LexoRankEntityDetails entityDetails, String sql, List<Object> params) {
        this.entityDetails = entityDetails;
        this.sql = sql;
        this.params.addAll(params);
    }

    public static SelectClause builder(LexoRankEntityDetails entityDetails, DatabaseType databaseType) {
        return new Builder(entityDetails, databaseType);
    }

    public String toSql() {
        return this.sql + " params" + this.params;
    }

    public ResultSet execute() throws SQLException {
        this.connection = this.entityDetails.getConnection();
        this.preparedStatement = this.connection.prepareStatement(this.sql);
        int parameterIndex = 1;
        for (Object param : this.params) {
            LexoRankEntityFieldUtils.setValue(this.preparedStatement, parameterIndex++, param);
        }
        return this.preparedStatement.executeQuery();
    }

    public void close() {
        Common.closeQuietly((Statement)this.preparedStatement);
        this.preparedStatement = null;
        Common.closeQuietly((Connection)this.connection);
        this.connection = null;
    }

    private static class Builder
    implements SelectClause,
    WhereClause,
    GroupByClause,
    HavingClause,
    OrderByClause,
    LimitClause,
    CompleteStatement {
        private LexoRankEntityDetails entityDetails;
        private DatabaseType databaseType;
        private String selectClause;
        private String whereClause;
        private String havingClause;
        private String groupByClause;
        private String orderByClause;
        private Integer limit;
        private List<Object> params = Lists.newArrayList();

        private Builder(LexoRankEntityDetails entityDetails, DatabaseType databaseType) {
            this.entityDetails = entityDetails;
            this.databaseType = databaseType;
        }

        @Override
        public SqlSelectStatement build() {
            switch (this.databaseType.getFamily()) {
                case ORACLE: {
                    return this.buildOracleStatement();
                }
                case MSSQL: {
                    return this.buildMSSqlStatement();
                }
            }
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ").append(this.selectClause).append(" FROM ").append(this.entityDetails.getTableName());
            if (this.whereClause != null) {
                String escapedWhereClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.whereClause);
                sql.append(" WHERE ").append(escapedWhereClause);
            }
            if (this.groupByClause != null) {
                String escapedGroupByClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.groupByClause);
                sql.append(" GROUP BY ").append(escapedGroupByClause);
                if (this.havingClause != null) {
                    String escapedHavingClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.havingClause);
                    sql.append(" HAVING ").append(escapedHavingClause);
                }
            }
            if (this.orderByClause != null) {
                sql.append(" ORDER BY ").append(this.orderByClause);
            }
            if (this.limit != null) {
                sql.append(" LIMIT ").append(this.limit);
            }
            sql.append(";");
            return new SqlSelectStatement(this.entityDetails, sql.toString(), this.params);
        }

        private SqlSelectStatement buildOracleStatement() {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ").append(this.selectClause).append(" FROM ").append(this.entityDetails.getTableName());
            String escapedWhereClause = null;
            if (this.whereClause != null) {
                escapedWhereClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.whereClause);
            }
            if (escapedWhereClause != null) {
                sql.append(" WHERE ").append(escapedWhereClause);
            }
            if (this.groupByClause != null) {
                String escapedGroupByClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.groupByClause);
                sql.append(" GROUP BY ").append(escapedGroupByClause);
                if (this.havingClause != null) {
                    String escapedHavingClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.havingClause);
                    sql.append(" HAVING ").append(escapedHavingClause);
                }
            }
            if (this.orderByClause != null) {
                sql.append(" ORDER BY ").append(this.orderByClause);
            }
            if (this.limit != null) {
                sql = new StringBuilder().append("SELECT ").append(this.selectClause).append(" FROM (").append(sql.toString()).append(") WHERE ROWNUM <= ").append(this.limit);
            }
            return new SqlSelectStatement(this.entityDetails, sql.toString(), this.params);
        }

        private SqlSelectStatement buildMSSqlStatement() {
            StringBuilder sql = new StringBuilder();
            if (this.limit != null) {
                this.selectClause = "TOP " + this.limit + " " + this.selectClause;
            }
            sql.append("SELECT ").append(this.selectClause).append(" FROM ").append(this.entityDetails.getTableName());
            if (this.whereClause != null) {
                String escapedWhereClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.whereClause);
                sql.append(" WHERE ").append(escapedWhereClause);
            }
            if (this.groupByClause != null) {
                String escapedGroupByClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.groupByClause);
                sql.append(" GROUP BY ").append(escapedGroupByClause);
                if (this.havingClause != null) {
                    String escapedHavingClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.havingClause);
                    sql.append(" HAVING ").append(escapedHavingClause);
                }
            }
            if (this.orderByClause != null) {
                sql.append(" ORDER BY ").append(this.orderByClause);
            }
            return new SqlSelectStatement(this.entityDetails, sql.toString(), this.params);
        }

        @Override
        public WhereClause select(String selectClause) {
            this.selectClause = selectClause;
            return this;
        }

        @Override
        public WhereClause count() {
            this.selectClause = "COUNT(*)";
            return this;
        }

        @Override
        public GroupByClause where(String whereClause, Object ... params) {
            this.whereClause = whereClause;
            this.params.addAll(Lists.newArrayList((Object[])params));
            return this;
        }

        @Override
        public GroupByClause emptyWhere() {
            return this;
        }

        @Override
        public HavingClause groupBy(String groupByClause, Object ... params) {
            this.groupByClause = groupByClause;
            this.params.addAll(Lists.newArrayList((Object[])params));
            return this;
        }

        @Override
        public OrderByClause having(String havingClause, Object ... params) {
            this.havingClause = havingClause;
            this.params.addAll(Lists.newArrayList((Object[])params));
            return this;
        }

        @Override
        public OrderByClause limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public LimitClause orderBy(String columnName, SqlSortOrder sortOrder) {
            String orderByClause = columnName + " " + sortOrder.getSql();
            this.orderByClause = this.orderByClause != null ? this.orderByClause + ", " + orderByClause : orderByClause;
            return this;
        }

        @Override
        public LimitClause orderBy(String columnName, SqlSortOrder sortOrder, SqlSortLanguage sortLanguage) {
            String orderByClause;
            if (!this.entityDetails.isCollationWorking()) {
                SqlExplicitSortLanguageFunction sortLanguageFunction = SqlExplicitSortLanguageFunction.builder().setColumnName(columnName).setSortLanguage(sortLanguage).build();
                orderByClause = sortLanguageFunction.toSql(this.databaseType) + " " + sortOrder.getSql();
            } else {
                orderByClause = columnName + " " + sortOrder.getSql();
            }
            this.orderByClause = this.orderByClause != null ? this.orderByClause + ", " + orderByClause : orderByClause;
            return this;
        }
    }

    public static interface CompleteStatement {
        public SqlSelectStatement build();
    }

    public static interface LimitClause
    extends OrderByClause {
        public OrderByClause limit(int var1);
    }

    public static interface HavingClause
    extends OrderByClause {
        public OrderByClause having(String var1, Object ... var2);
    }

    public static interface GroupByClause
    extends OrderByClause {
        public HavingClause groupBy(String var1, Object ... var2);
    }

    public static interface OrderByClause
    extends CompleteStatement {
        public LimitClause orderBy(String var1, SqlSortOrder var2);

        public LimitClause orderBy(String var1, SqlSortOrder var2, SqlSortLanguage var3);
    }

    public static interface WhereClause
    extends OrderByClause {
        public GroupByClause where(String var1, Object ... var2);

        public GroupByClause emptyWhere();
    }

    public static interface SelectClause {
        public WhereClause select(String var1);

        public WhereClause count();
    }
}

