/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.util.database.DatabaseType;

public class SqlPositionFunction {
    private String columnName;
    private String substring;

    private SqlPositionFunction(String columnName, String substring) {
        this.columnName = columnName;
        this.substring = substring;
    }

    public static IndexOfSubstring builder() {
        return new Builder();
    }

    public String toSql(DatabaseType dbType) {
        switch (dbType.getFamily()) {
            case ORACLE: {
                return "INSTR(" + this.columnName + ",'" + this.substring + "')";
            }
            case MSSQL: {
                return "CHARINDEX('" + this.substring + "', " + this.columnName + ")";
            }
        }
        return "POSITION('" + this.substring + "' IN " + this.columnName + ")";
    }

    public static interface CompletePositionFunction {
        public SqlPositionFunction build();
    }

    public static interface IndexOfSubstring {
        public InColumnName indexOf(String var1);
    }

    public static interface InColumnName {
        public CompletePositionFunction inColumn(String var1);
    }

    private static class Builder
    implements InColumnName,
    IndexOfSubstring,
    CompletePositionFunction {
        private String columnName;
        private String substring;

        private Builder() {
        }

        @Override
        public SqlPositionFunction build() {
            return new SqlPositionFunction(this.columnName, this.substring);
        }

        @Override
        public CompletePositionFunction inColumn(String columnName) {
            this.columnName = columnName;
            return this;
        }

        @Override
        public InColumnName indexOf(String substring) {
            this.substring = substring;
            return this;
        }
    }
}

