/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.SqlSortLanguage;
import com.atlassian.greenhopper.util.database.DatabaseFamily;
import com.atlassian.greenhopper.util.database.DatabaseType;

public class SqlExplicitSortLanguageFunction {
    private String columnName;
    private SqlSortLanguage sortLanguage;

    private SqlExplicitSortLanguageFunction(String columnName, SqlSortLanguage sortLanguage) {
        this.columnName = columnName;
        this.sortLanguage = sortLanguage;
    }

    public String toSql(DatabaseType dbType) {
        switch (dbType.getFamily()) {
            case ORACLE: {
                return "NLSSORT(" + this.columnName + ", 'NLS_SORT = " + this.sortLanguage.getProperty(DatabaseFamily.ORACLE) + "')";
            }
            case MYSQL: {
                return "convert(" + this.columnName + " using 'utf8') COLLATE " + this.sortLanguage.getProperty(DatabaseFamily.MYSQL);
            }
            case MSSQL: {
                return this.columnName + " COLLATE " + this.sortLanguage.getProperty(dbType.getFamily());
            }
            case POSTGRES: {
                if (dbType != DatabaseType.POSTGRESQL) break;
                return this.columnName + " COLLATE \"" + this.sortLanguage.getProperty(dbType.getFamily()) + "\"";
            }
        }
        return this.columnName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String columnName;
        private SqlSortLanguage sortLanguage;

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setSortLanguage(SqlSortLanguage sortLanguage) {
            this.sortLanguage = sortLanguage;
            return this;
        }

        public SqlExplicitSortLanguageFunction build() {
            return new SqlExplicitSortLanguageFunction(this.columnName, this.sortLanguage);
        }
    }
}

