/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityFieldUtils;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class SqlDeleteStatement {
    private LexoRankEntityDetails entityDetails;
    private String sql;
    private List<Object> params;

    private SqlDeleteStatement(LexoRankEntityDetails entityDetails, String sql, List<Object> params) {
        this.entityDetails = entityDetails;
        this.sql = sql;
        this.params = params;
    }

    public static WhereClause builder(LexoRankEntityDetails entityDetails) {
        return new Builder(entityDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws SQLException {
        try (Connection connection = this.entityDetails.getConnection();){
            int n;
            PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
            try {
                int parameterIndex = 1;
                for (Object param : this.params) {
                    if (param == null) {
                        preparedStatement.setNull(parameterIndex, 12);
                    } else {
                        LexoRankEntityFieldUtils.setValue(preparedStatement, parameterIndex, param);
                    }
                    ++parameterIndex;
                }
                n = preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                preparedStatement.close();
                throw throwable;
            }
            preparedStatement.close();
            return n;
        }
    }

    public String toSql() {
        return this.sql + " params" + this.params;
    }

    private static class Builder
    implements WhereClause,
    CompleteStatement {
        private LexoRankEntityDetails entityDetails;
        private String whereClause;
        private List<Object> params = Lists.newArrayList();

        private Builder(LexoRankEntityDetails entityDetails) {
            this.entityDetails = entityDetails;
        }

        @Override
        public SqlDeleteStatement build() {
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ").append(this.entityDetails.getTableName());
            if (this.whereClause != null) {
                String escapedWhereClause = this.entityDetails.getDatabaseProvider().processWhereClause(this.whereClause);
                sql.append(" WHERE ").append(escapedWhereClause);
            }
            return new SqlDeleteStatement(this.entityDetails, sql.toString(), this.params);
        }

        @Override
        public CompleteStatement where(String whereClause, Object ... params) {
            this.whereClause = whereClause;
            this.params.addAll(Lists.newArrayList((Object[])params));
            return this;
        }
    }

    public static interface CompleteStatement {
        public SqlDeleteStatement build();
    }

    public static interface WhereClause
    extends CompleteStatement {
        public CompleteStatement where(String var1, Object ... var2);
    }
}

