/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.CommonSqlBulkInsertBuilder;
import com.atlassian.greenhopper.manager.lexorank.OracleSqlBulkInsertBuilder;
import com.atlassian.greenhopper.util.database.DatabaseFamily;
import com.atlassian.greenhopper.util.database.DatabaseType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.java.ao.DatabaseProvider;

public abstract class SqlBulkInsertBuilder {
    protected DatabaseProvider dbProvider;
    protected String tableName;
    protected Set<String> columnNames = Sets.newLinkedHashSet();
    protected List<String> rows = Lists.newArrayList();

    protected SqlBulkInsertBuilder(DatabaseProvider dbProvider) {
        this.dbProvider = dbProvider;
    }

    public SqlBulkInsertBuilder table(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SqlBulkInsertBuilder column(String columnName) {
        this.columnNames.add(columnName);
        return this;
    }

    public abstract SqlBulkInsertBuilder row(Object ... var1);

    public abstract String build();

    public static SqlBulkInsertBuilder makeBuilder(DatabaseProvider dbProvider, DatabaseType dbType) {
        if (dbType.isFamilyOf(DatabaseFamily.ORACLE)) {
            return new OracleSqlBulkInsertBuilder(dbProvider);
        }
        return new CommonSqlBulkInsertBuilder(dbProvider);
    }
}

