/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.SqlBulkInsertBuilder;
import java.util.Iterator;
import net.java.ao.DatabaseProvider;

public class OracleSqlBulkInsertBuilder
extends SqlBulkInsertBuilder {
    protected OracleSqlBulkInsertBuilder(DatabaseProvider dbProvider) {
        super(dbProvider);
    }

    @Override
    public SqlBulkInsertBuilder row(Object ... cellValues) {
        StringBuilder row = new StringBuilder("");
        for (Object cellValue : cellValues) {
            if (cellValue instanceof Number) {
                row.append(cellValue + ",");
                continue;
            }
            row.append("'" + cellValue + "',");
        }
        row.deleteCharAt(row.length() - 1);
        this.rows.add(row.toString());
        return this;
    }

    @Override
    public String build() {
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.dbProvider.withSchema(this.tableName) + " (");
        Iterator columnNamesIterator = this.columnNames.iterator();
        while (columnNamesIterator.hasNext()) {
            String columnName = (String)columnNamesIterator.next();
            sql.append(this.dbProvider.processID(columnName));
            if (!columnNamesIterator.hasNext()) continue;
            sql.append(",");
        }
        sql.append(")\n");
        Iterator rowIterator = this.rows.iterator();
        while (rowIterator.hasNext()) {
            String row = (String)rowIterator.next();
            sql.append("SELECT " + row + " FROM DUAL\n");
            if (!rowIterator.hasNext()) continue;
            sql.append("UNION ALL ");
        }
        return sql.toString();
    }
}

