/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;

public class LexoRankRow {
    private Long id;
    private Long fieldId;
    private Long issueId;
    private String lockHash;
    private Long lockTime;
    private int bucket;
    private String rank;
    private RankRowType type;

    public static LexoRankRow fromAO(LexoRankAO ao) {
        return LexoRankRow.builder().id(ao.getId()).forRankField(ao.getFieldId()).forIssue(ao.getIssueId()).withRank(ao.getRank()).ofType(ao.getType()).withLock(ao.getLockHash(), ao.getLockTime()).build();
    }

    private LexoRankRow(Long id, Long fieldId, Long issueId, String rank, RankRowType type, String lockHash, Long lockTime) {
        this.id = id;
        this.fieldId = fieldId;
        this.issueId = issueId;
        this.setRank(rank);
        this.type = type;
        this.lockHash = lockHash;
        this.lockTime = lockTime;
    }

    public static WithId builder() {
        return new Builder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(Long fieldId) {
        this.fieldId = fieldId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public String getLockHash() {
        return this.lockHash;
    }

    public Long getLockTime() {
        return this.lockTime;
    }

    public Integer getBucket() {
        return this.bucket;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
        this.bucket = LexoRankBucket.fromRank(rank).intValue();
    }

    public RankRowType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexoRankRow that = (LexoRankRow)o;
        if (!this.fieldId.equals(that.fieldId)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.issueId.equals(that.issueId)) {
            return false;
        }
        if (!this.rank.equals(that.rank)) {
            return false;
        }
        return this.type.equals((Object)that.type);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.fieldId.hashCode();
        result = 31 * result + this.issueId.hashCode();
        result = 31 * result + this.rank.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "LexoRankRow{id=" + this.id + ", fieldId=" + this.fieldId + ", issueId=" + this.issueId + ", lockHash='" + this.lockHash + '\'' + ", lockTime=" + this.lockTime + ", bucket=" + this.bucket + ", rank='" + this.rank + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static interface CompleteLexoRankRow {
        public LexoRankRow build();
    }

    public static interface WithLock
    extends CompleteLexoRankRow {
        public CompleteLexoRankRow withLock(String var1, Long var2);
    }

    public static interface OfType {
        public WithLock ofType(Integer var1);

        public WithLock ofType(RankRowType var1);
    }

    public static interface WithRank {
        public OfType withRank(String var1);
    }

    public static interface ForIssue {
        public WithRank forIssue(Long var1);
    }

    public static interface ForRankField {
        public ForIssue forRankField(Long var1);
    }

    public static interface WithId {
        public ForRankField id(Long var1);
    }

    private static class Builder
    implements WithId,
    ForRankField,
    ForIssue,
    WithRank,
    OfType,
    WithLock,
    CompleteLexoRankRow {
        private Long id;
        private Long fieldId;
        private Long issueId;
        private String lockHash;
        private Long lockTime;
        private String rank;
        private RankRowType type;

        private Builder() {
        }

        @Override
        public WithRank forIssue(Long issueId) {
            this.issueId = issueId;
            return this;
        }

        @Override
        public CompleteLexoRankRow withLock(String hash, Long time) {
            this.lockHash = hash;
            this.lockTime = time != null && time == 0L ? null : time;
            return this;
        }

        @Override
        public LexoRankRow build() {
            return new LexoRankRow(this.id, this.fieldId, this.issueId, this.rank, this.type, this.lockHash, this.lockTime);
        }

        @Override
        public ForIssue forRankField(Long rankFieldId) {
            this.fieldId = rankFieldId;
            return this;
        }

        @Override
        public WithLock ofType(Integer typeId) {
            this.type = RankRowType.resolve(typeId);
            return this;
        }

        @Override
        public ForRankField id(Long id) {
            this.id = id;
            return this;
        }

        @Override
        public OfType withRank(String rank) {
            this.rank = rank;
            return this;
        }

        @Override
        public WithLock ofType(RankRowType type) {
            this.type = type;
            return this;
        }
    }

    public static enum RankRowType {
        MINIMUM_MARKER_ROW(0),
        ISSUE_RANK_ROW(1),
        MAXIMUM_MARKER_ROW(2),
        COLLATION_CHECK_ROW(3);

        private final Integer id;

        private RankRowType(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }

        public static RankRowType resolve(Integer typeId) {
            for (RankRowType type : RankRowType.values()) {
                if (!type.getId().equals(typeId)) continue;
                return type;
            }
            throw new IllegalArgumentException("No RankRowType with id " + typeId);
        }
    }
}

