/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.lock.Lock;
import com.atlassian.greenhopper.manager.lexorank.lock.LockOutcome;
import com.atlassian.greenhopper.manager.lexorank.lock.LockProcessOutcome;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.lexorank.BackoffHandler;
import com.atlassian.greenhopper.service.lexorank.LexoRankBulkDeleteOperation;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankDeleteOperation;
import com.atlassian.greenhopper.service.lexorank.LexoRankHealOperation;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperation;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankChangeEvent;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankManagerImpl
implements LexoRankManager {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final int RETRY_TIMEOUT_MS = 2000;
    @Autowired
    private LexoRankDao lexoRankDao;
    @Autowired
    private IssueIndexService issueIndexService;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private LexoRankStatisticsAgent lexoRankStatisticsAgent;
    private Function<Pair<LexoRankChange, Set<Long>>, RankChange> toRankChange = new Function<Pair<LexoRankChange, Set<Long>>, RankChange>(){

        public RankChange apply(Pair<LexoRankChange, Set<Long>> input) {
            return (RankChange)input.left();
        }
    };

    @Override
    public ServiceOutcome<Void> initField(long fieldId) {
        Option<LexoRankRow> minAo = this.lexoRankDao.findMinimumMarkerRow(fieldId);
        if (minAo.isEmpty()) {
            this.lexoRankDao.createMarkerRowsForRankField(fieldId);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Set<Long>> dropField(long fieldId) {
        return this.dropField(fieldId, System.currentTimeMillis() + 2000L);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> getRankOrRankInitially(long fieldId, long issueId) {
        return this.getRankOrRankInitially(fieldId, issueId, true);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> getRankOrRankInitially(long fieldId, long issueId, boolean reIndex) {
        LexoRankOperation rankOperation = LexoRankOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).rankIssue(issueId).initial().forRankField(fieldId).build();
        LexoRankOperationOutcome<LexoRankChange> rankResult = this.performRankOperation(rankOperation);
        if (reIndex) {
            this.reIndexIssues(rankResult);
        }
        return rankResult;
    }

    @Override
    public ServiceOutcome<Void> deleteRanksForDeletedIssue(long issueId) {
        LexoRankDeleteOperation deleteOperation = LexoRankDeleteOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).forIssue(issueId).build();
        LexoRankOperationOutcome<Void> deleteOperationOutcome = deleteOperation.execute();
        if (deleteOperationOutcome.isValid()) {
            return ServiceOutcomeImpl.ok();
        }
        return ServiceOutcomeImpl.from(deleteOperationOutcome.getErrors());
    }

    @Override
    public ServiceOutcome<Void> deleteRanksForIssues(Iterable<Long> issueIds) {
        LexoRankBulkDeleteOperation bulkDeleteOperation = LexoRankBulkDeleteOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).forIssues(issueIds).build();
        LexoRankOperationOutcome<Void> bulkDeleteOperationOutcome = bulkDeleteOperation.execute();
        if (bulkDeleteOperationOutcome.isValid()) {
            return ServiceOutcomeImpl.ok();
        }
        return ServiceOutcomeImpl.from(bulkDeleteOperationOutcome.getErrors());
    }

    @Override
    public ServiceOutcome<Void> deleteRanksForIssueIdsBetween(long startIdInclusive, long endIdInclusive) {
        if (startIdInclusive > endIdInclusive) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "startIdInclusive (%d) must be <= endIdInclusive (%d)", startIdInclusive, endIdInclusive);
        }
        List<Long> issueIds = this.lexoRankDao.listIssueIdsBetween(startIdInclusive, endIdInclusive);
        return this.deleteRanksForIssues(issueIds);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> rankBefore(long fieldId, long issueId, long otherIssueId) {
        return this.rankBefore(fieldId, issueId, otherIssueId, 0);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> rankBefore(long fieldId, long issueId, long otherIssueId, int remainingRankOperations) {
        LexoRankOperation rankOperation = LexoRankOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).rankIssue(issueId).beforeIssue(otherIssueId).forRankField(fieldId).withRemainingRankOperations(remainingRankOperations).build();
        return this.performRankOperation(rankOperation);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> rankAfter(long fieldId, long issueId, long otherIssueId) {
        return this.rankAfter(fieldId, issueId, otherIssueId, 0);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> rankAfter(long fieldId, long issueId, long otherIssueId, int remainingRankOperations) {
        LexoRankOperation rankOperation = LexoRankOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).rankIssue(issueId).afterIssue(otherIssueId).forRankField(fieldId).withRemainingRankOperations(remainingRankOperations).build();
        return this.performRankOperation(rankOperation);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> rankFirst(long fieldId, long issueId) {
        LexoRankOperation rankOperation = LexoRankOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).rankIssue(issueId).first().forRankField(fieldId).build();
        return this.performRankOperation(rankOperation);
    }

    @Override
    public LexoRankOperationOutcome<LexoRankChange> rankLast(long fieldId, long issueId) {
        LexoRankOperation rankOperation = LexoRankOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).rankIssue(issueId).last().forRankField(fieldId).build();
        return this.performRankOperation(rankOperation);
    }

    @Override
    public ServiceOutcome<Void> healDuplicates(long fieldId) {
        Map<String, Long> duplicateRowsForFieldId = this.lexoRankDao.countDuplicateRowsForFieldId(fieldId);
        this.log.info("Detected %d duplicate ranks. Healing duplicates.", duplicateRowsForFieldId.size());
        for (String rank : duplicateRowsForFieldId.keySet()) {
            List<LexoRankRow> lexoRankRows = this.lexoRankDao.listByFieldIdAndRank(fieldId, rank);
            LexoRankHealOperation healOperation = LexoRankHealOperation.builder(this.lexoRankDao, this.lexoRankStatisticsAgent).forRankField(fieldId).heal(lexoRankRows.toArray(new LexoRankRow[0])).build();
            LexoRankOperationOutcome<Boolean> healOperationOutcome = healOperation.execute();
            this.log.info("Healed %d rank rows with duplicate rank %s", lexoRankRows.size(), rank);
            if (healOperationOutcome.isValid()) {
                this.issueIndexService.reindexIssuesAndSubtasks(healOperationOutcome.getIssueIdsToReIndex());
                continue;
            }
            return ServiceOutcomeImpl.from(healOperationOutcome.getErrors());
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public Option<LexoRank> getRank(long fieldId, long issueId) {
        Option<LexoRankRow> maybeRankAo = this.lexoRankDao.findByFieldAndIssueId(fieldId, issueId);
        return maybeRankAo.map((java.util.function.Function)new Function<LexoRankRow, LexoRank>(){

            public LexoRank apply(LexoRankRow lexoRankRow) {
                return LexoRank.parse(lexoRankRow.getRank());
            }
        });
    }

    @Override
    public Map<Long, LexoRank> getRankValues(long fieldId, Collection<Long> issueIds) {
        LexoRankRow[] rows = this.lexoRankDao.findByIssueIds(fieldId, issueIds);
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)issueIds.size());
        for (LexoRankRow row : rows) {
            valueMap.put(row.getIssueId(), LexoRank.parse(row.getRank()));
        }
        return valueMap;
    }

    private ServiceOutcome<Set<Long>> dropField(long fieldId, long retryTimeout) {
        BackoffHandler backoffHandler = new BackoffHandler(this.lexoRankStatisticsAgent, retryTimeout);
        while (System.currentTimeMillis() < retryTimeout) {
            backoffHandler.maybeWait();
            Set<Long> affectedIssuesIds = this.lexoRankDao.findIssueIdsByFieldId(fieldId);
            LockOutcome lockOutcome = this.lexoRankDao.acquireLockByFieldId(fieldId);
            if (lockOutcome.isInvalid()) {
                if (lockOutcome.isFailRetry()) continue;
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, lockOutcome.getFailDetails(), new Object[0]);
            }
            Lock lock = lockOutcome.get();
            LockProcessOutcome<ServiceOutcome<Void>> deleteProcessOutcome = this.lexoRankDao.deleteByFieldId(lock, fieldId);
            if (deleteProcessOutcome.isRetry()) continue;
            return ServiceOutcomeImpl.ok(affectedIssuesIds);
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.lexorank.service.error.retrytimeout", new Object[0]);
    }

    private LexoRankOperationOutcome<LexoRankChange> performRankOperation(LexoRankOperation rankOperation) {
        LexoRankChange lexoRankChange;
        LexoRankOperationOutcome<LexoRankChange> rankOperationOutcome = rankOperation.execute();
        if (rankOperationOutcome.isValid() && (lexoRankChange = rankOperationOutcome.getResult()).wasChanged()) {
            this.eventPublisher.publish((Object)new LexoRankChangeEvent(lexoRankChange));
        }
        return rankOperationOutcome;
    }

    private void reIndexIssues(LexoRankOperationOutcome<LexoRankChange> lexoRankOperationOutcome) {
        if (lexoRankOperationOutcome.isValid()) {
            this.issueIndexService.reindexIssuesAndSubtasks(lexoRankOperationOutcome.getIssueIdsToReIndex());
        }
    }
}

