/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Pair;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.ao.Common;
import net.java.ao.EntityManager;

public class LexoRankEntityFieldUtils {
    private static final Map<Class, DBSetter> SETTERS = new HashMap<Class, DBSetter>();

    public static <T> DBSetter<T> getSetterFor(Class<T> clazz) {
        DBSetter setter = SETTERS.get(clazz);
        if (setter == null) {
            throw new RuntimeException("Type currently not supported");
        }
        return setter;
    }

    public static void setValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        DBSetter<?> setter = LexoRankEntityFieldUtils.getSetterFor(value.getClass());
        setter.setValue(stmt, index, value);
    }

    public static <T> String getLockHashColumn(EntityManager entityManager, Class<T> entityType) {
        return LexoRankEntityFieldUtils.getColumnName(entityManager, entityType, LexoRankAO.ColumnDetails.LOCK_HASH.getMethodName());
    }

    public static <T> String getLockTimeColumn(EntityManager entityManager, Class<T> entityType) {
        return LexoRankEntityFieldUtils.getColumnName(entityManager, entityType, LexoRankAO.ColumnDetails.LOCK_TIME.getMethodName());
    }

    public static <T> String getColumnName(EntityManager entityManager, Class<T> entityType, String methodName) {
        try {
            Method m = entityType.getMethod(methodName, new Class[0]);
            return entityManager.getFieldNameConverter().getName(m);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<Pair<String, Method>> findEntityFields(EntityManager entityManager, Class<T> entityType) {
        Method[] methods;
        ArrayList result = Lists.newArrayList();
        for (Method method : methods = entityType.getDeclaredMethods()) {
            if (!Common.isAccessor((Method)method)) continue;
            String name = entityManager.getFieldNameConverter().getName(method);
            result.add(Pair.pair((Object)name, (Object)method));
        }
        return result;
    }

    public static <T> Map<String, Object> fillValues(T entity, List<Pair<String, Method>> fields) {
        HashMap values = Maps.newHashMap();
        for (Pair<String, Method> field : fields) {
            try {
                Object value = ((Method)field.right()).invoke(entity, new Object[0]);
                values.put(field.left(), value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return values;
    }

    static {
        SETTERS.put(String.class, new DBSetter<String>(){

            @Override
            public void setValue(PreparedStatement stmt, int index, String value) throws SQLException {
                stmt.setString(index, value);
            }
        });
        SETTERS.put(Long.class, new DBSetter<Long>(){

            @Override
            public void setValue(PreparedStatement stmt, int index, Long value) throws SQLException {
                stmt.setLong(index, value);
            }
        });
        SETTERS.put(Integer.class, new DBSetter<Integer>(){

            @Override
            public void setValue(PreparedStatement stmt, int index, Integer value) throws SQLException {
                stmt.setInt(index, value);
            }
        });
    }

    public static interface DBSetter<T> {
        public void setValue(PreparedStatement var1, int var2, T var3) throws SQLException;
    }
}

