/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDaoContext;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.LexoRankIntegrityException;
import com.atlassian.greenhopper.manager.lexorank.LexoRankRow;
import com.atlassian.greenhopper.manager.lexorank.SqlDeleteStatement;
import com.atlassian.greenhopper.manager.lexorank.SqlSelectStatement;
import com.atlassian.greenhopper.manager.lexorank.SqlSortLanguage;
import com.atlassian.greenhopper.manager.lexorank.SqlSortOrder;
import com.atlassian.greenhopper.manager.lexorank.SqlUpdateStatement;
import com.atlassian.greenhopper.manager.lexorank.collation.CollationIntegrityChecker;
import com.atlassian.greenhopper.manager.lexorank.lock.Lock;
import com.atlassian.greenhopper.manager.lexorank.lock.LockOutcome;
import com.atlassian.greenhopper.manager.lexorank.lock.LockProcessOutcome;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.schema.querydsl.current.QLexoRank;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.pocketknife.api.querydsl.QueryFactory;
import com.atlassian.pocketknife.api.querydsl.SchemaProvider;
import com.atlassian.pocketknife.api.querydsl.SelectQuery;
import com.atlassian.pocketknife.api.querydsl.StreamyResult;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import io.atlassian.fugue.Option;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.java.ao.Common;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankDaoImpl
implements LexoRankDao {
    private static final int IN_CLAUSE_BATCH = 1000;
    static final int LOCK_TIMEOUT_MILLIS = 1500;
    private static final int UPDATE_TIMEOUT_SECONDS = 2;
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private volatile LexoRankDaoContext context;
    @Autowired
    protected ActiveObjects ao;
    @Autowired
    private CollationIntegrityChecker checker;
    @Autowired
    private QueryFactory queryFactory;
    @Autowired
    private SchemaProvider schemaProvider;

    @Override
    public void createMarkerRowsForRankField(long fieldId) {
        this.ao.create(LexoRankAO.class, (Map)ImmutableMap.of((Object)"FIELD_ID", (Object)fieldId, (Object)"ISSUE_ID", (Object)Long.MIN_VALUE, (Object)"TYPE", (Object)LexoRankRow.RankRowType.MINIMUM_MARKER_ROW.getId(), (Object)"BUCKET", (Object)LexoRank.min().getBucket().intValue(), (Object)"RANK", (Object)LexoRank.min().format()));
        this.ao.create(LexoRankAO.class, (Map)ImmutableMap.of((Object)"FIELD_ID", (Object)fieldId, (Object)"ISSUE_ID", (Object)Long.MAX_VALUE, (Object)"TYPE", (Object)LexoRankRow.RankRowType.MAXIMUM_MARKER_ROW.getId(), (Object)"BUCKET", (Object)LexoRank.max().getBucket().intValue(), (Object)"RANK", (Object)LexoRank.max().format()));
    }

    @Override
    public LexoRankRow create(long fieldId, long issueId, String rank) {
        return LexoRankRow.fromAO(this.createAO(fieldId, issueId, rank));
    }

    private LexoRankAO createAO(long fieldId, long issueId, String rank) {
        return (LexoRankAO)this.ao.create(LexoRankAO.class, (Map)ImmutableMap.of((Object)"FIELD_ID", (Object)fieldId, (Object)"ISSUE_ID", (Object)issueId, (Object)"TYPE", (Object)LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId(), (Object)"BUCKET", (Object)LexoRankBucket.fromRank(rank).intValue(), (Object)"RANK", (Object)rank));
    }

    @Override
    public List<Long> listIssueIdsByFieldIdAndIssueIds(long fieldId, List<Long> issueIds) {
        if (issueIds.size() == 0) {
            return Lists.newArrayList();
        }
        LexoRankDaoContext lexoRankDaoContext = this.getContext();
        LexoRankEntityDetails entityDetails = lexoRankDaoContext.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String issueIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String whereClause = fieldIdColumnName + " = ? AND " + issueIdColumnName + " IN(" + this.makeQuestionsList(issueIds) + ")";
        ArrayList<Long> whereParams = new ArrayList<Long>();
        whereParams.add(fieldId);
        whereParams.addAll(issueIds);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, lexoRankDaoContext.getDatabaseType()).select(issueIdColumnName).where(whereClause, whereParams.toArray()).build();
        ResultSet resultSet = null;
        try {
            resultSet = selectStatement.execute();
            LinkedList issueIdsWithExistingLexoRank = Lists.newLinkedList();
            while (resultSet.next()) {
                issueIdsWithExistingLexoRank.add(resultSet.getLong(1));
            }
            LinkedList linkedList = issueIdsWithExistingLexoRank;
            return linkedList;
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to query LexoRank rows", (Throwable)e);
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            selectStatement.close();
        }
    }

    @Override
    public LexoRankRow[] findByIssueIds(long fieldId, Iterable<Long> issueIds) {
        return this.findByOptionalItemIds(fieldId, issueIds);
    }

    @Override
    public LexoRankRow[] findByFieldId(long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement sqlSelectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ?", fieldId).orderBy(rankColumnName, SqlSortOrder.ASC, SqlSortLanguage.BINARY).build();
        List<LexoRankRow> lexoRankRows = this.find(sqlSelectStatement);
        return lexoRankRows.toArray(new LexoRankRow[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LexoRankDaoContext getContext() {
        if (this.context == null) {
            LexoRankDaoImpl lexoRankDaoImpl = this;
            synchronized (lexoRankDaoImpl) {
                if (this.context == null) {
                    this.context = this.checker.getLexoRankDaoContext();
                }
            }
        }
        return this.context;
    }

    @Override
    public LexoRankRow[] findByIssueId(long issueId) {
        LexoRankDaoContext ctx = this.getContext();
        String issueIdColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String typeColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.TYPE);
        String fieldIdColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(issueIdColumnName + " = ? AND " + typeColumnName + " = ?", issueId, LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId()).orderBy(fieldIdColumnName, SqlSortOrder.ASC).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        return lexoRankRows.toArray(new LexoRankRow[0]);
    }

    @Override
    public LexoRankRow[] findByIssueIds(Iterable<Long> issueIds) {
        return this.findByOptionalItemIds(null, issueIds);
    }

    @Override
    public Option<LexoRankRow> findByFieldAndIssueId(long fieldId, long issueId) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String issueIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String typeColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.TYPE);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + issueIdColumnName + " = ? AND " + typeColumnName + " = ?", fieldId, issueId, LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId()).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        if (lexoRankRows.size() == 0) {
            return Option.none();
        }
        if (lexoRankRows.size() > 1) {
            throw new LexoRankIntegrityException(String.format("Expected exactly one rank row for issue[id=%d] for rank field[id=%d], but found %d rows", issueId, fieldId, lexoRankRows.size()));
        }
        return Option.some((Object)lexoRankRows.get(0));
    }

    @Override
    public LexoRankRow getByFieldAndIssueId(long fieldId, long issueId) {
        Option<LexoRankRow> maybeAo = this.findByFieldAndIssueId(fieldId, issueId);
        if (maybeAo.isEmpty()) {
            throw new LexoRankIntegrityException(String.format("Expected exactly one rank row for issue[id=%d] for rank field[id=%d], but found none", issueId, fieldId));
        }
        return (LexoRankRow)maybeAo.get();
    }

    @Override
    public Option<LexoRankRow> findMinimumMarkerRow(long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        String typeColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.TYPE);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + typeColumnName + " = ?", fieldId, LexoRankRow.RankRowType.MINIMUM_MARKER_ROW.getId()).orderBy(rankColumnName, SqlSortOrder.ASC, SqlSortLanguage.BINARY).limit(1).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        if (lexoRankRows.size() == 0) {
            return Option.none();
        }
        if (lexoRankRows.size() > 1) {
            throw new LexoRankIntegrityException(String.format("Expected exactly one minimum marker row for rank field[id=%d], but found %d", fieldId, lexoRankRows.size()));
        }
        if (!lexoRankRows.get(0).getType().equals((Object)LexoRankRow.RankRowType.MINIMUM_MARKER_ROW)) {
            throw new LexoRankIntegrityException(String.format("Expected the rank row to be of type %s. Found row[%s]", new Object[]{LexoRankRow.RankRowType.MINIMUM_MARKER_ROW, lexoRankRows.get(0).toString()}));
        }
        return Option.some((Object)lexoRankRows.get(0));
    }

    @Override
    public LexoRankRow getMinimumMarkerRow(long fieldId) {
        Option<LexoRankRow> maybeAo = this.findMinimumMarkerRow(fieldId);
        if (maybeAo.isEmpty()) {
            throw new LexoRankIntegrityException(String.format("Expected to find minimum marker row for rank field[id=%d], but found none.", fieldId));
        }
        return (LexoRankRow)maybeAo.get();
    }

    @Override
    public Option<LexoRankRow> findMaximumMarkerRow(long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        String typeColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.TYPE);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + typeColumnName + " = ?", fieldId, LexoRankRow.RankRowType.MAXIMUM_MARKER_ROW.getId()).orderBy(rankColumnName, SqlSortOrder.DESC, SqlSortLanguage.BINARY).limit(1).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        if (lexoRankRows.size() == 0) {
            return Option.none();
        }
        if (lexoRankRows.size() > 1) {
            throw new LexoRankIntegrityException(String.format("Expected exactly one maximum marker row for rank field[id=%d], but found %d", fieldId, lexoRankRows.size()));
        }
        if (!lexoRankRows.get(0).getType().equals((Object)LexoRankRow.RankRowType.MAXIMUM_MARKER_ROW)) {
            throw new LexoRankIntegrityException(String.format("Expected the rank row to be of type %s. Found row[%s]", new Object[]{LexoRankRow.RankRowType.MAXIMUM_MARKER_ROW, lexoRankRows.get(0).toString()}));
        }
        return Option.some((Object)lexoRankRows.get(0));
    }

    @Override
    public LexoRankRow getMaximumMarkerRow(long fieldId) {
        Option<LexoRankRow> maybeAo = this.findMaximumMarkerRow(fieldId);
        if (maybeAo.isEmpty()) {
            throw new LexoRankIntegrityException(String.format("Expected to find maximum marker row for rank field[id=%d], but found none.", fieldId));
        }
        return (LexoRankRow)maybeAo.get();
    }

    @Override
    public Option<LexoRankRow> findMaximumRankLengthRow(long fieldId) {
        QLexoRank LEXORANK = QLexoRank.withSchema(this.schemaProvider);
        Integer typeId = LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId();
        return Option.option((Object)this.queryFactory.select((Function<SelectQuery, StreamyResult>)((Function)select -> select.from((Expression<?>)LEXORANK).where((Predicate)LEXORANK.FIELD_ID.eq(fieldId).and(LEXORANK.TYPE.eq(typeId))).orderBy(LEXORANK.RANK.length().desc(), LEXORANK.RANK.desc()).limit(1L).stream(LEXORANK.all()))).map(tuple -> LexoRankRow.builder().id(tuple.get(LEXORANK.ID).longValue()).forRankField(tuple.get(LEXORANK.FIELD_ID)).forIssue(tuple.get(LEXORANK.ISSUE_ID)).withRank(tuple.get(LEXORANK.RANK)).ofType(tuple.get(LEXORANK.TYPE)).build()).fetchFirst().getOrNull());
    }

    @Override
    public LexoRankRow[] getMinimumMarkerRowAndNextRow(long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ?", fieldId).orderBy(rankColumnName, SqlSortOrder.ASC, SqlSortLanguage.BINARY).limit(2).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        if (lexoRankRows.size() != 2) {
            throw new LexoRankIntegrityException(String.format("Expected exactly 2 rows; the minimum marker row and the highest ranked row for rank field[id=%d]", fieldId));
        }
        if (!lexoRankRows.get(0).getType().equals((Object)LexoRankRow.RankRowType.MINIMUM_MARKER_ROW)) {
            throw new LexoRankIntegrityException(String.format("Expected the first rank row to be of type %s. Found row[%s]", new Object[]{LexoRankRow.RankRowType.MINIMUM_MARKER_ROW, lexoRankRows.get(0).toString()}));
        }
        return lexoRankRows.toArray(new LexoRankRow[0]);
    }

    @Override
    public LexoRankRow[] getMaximumMarkerRowAndPreviousRow(long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ?", fieldId).orderBy(rankColumnName, SqlSortOrder.DESC, SqlSortLanguage.BINARY).limit(2).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        if (lexoRankRows.size() != 2) {
            throw new LexoRankIntegrityException(String.format("Expected exactly 2 rows; the maximum marker row and the lowest ranked row for rank field[id=%d]", fieldId));
        }
        if (!lexoRankRows.get(0).getType().equals((Object)LexoRankRow.RankRowType.MAXIMUM_MARKER_ROW)) {
            throw new LexoRankIntegrityException(String.format("Expected the first rank row to be of type %s. Found row[%s]", new Object[]{LexoRankRow.RankRowType.MAXIMUM_MARKER_ROW, lexoRankRows.get(0).toString()}));
        }
        return lexoRankRows.toArray(new LexoRankRow[0]);
    }

    @Override
    public LexoRankRow[] getRowByRankAndNextRow(long fieldId, String rank) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + rankColumnName + " >= ?", fieldId, rank).orderBy(rankColumnName, SqlSortOrder.ASC, SqlSortLanguage.BINARY).limit(2).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        return lexoRankRows.toArray(new LexoRankRow[0]);
    }

    @Override
    public LexoRankRow findNextOneByRank(long fieldId, String rank) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + rankColumnName + " > ?", fieldId, rank).orderBy(rankColumnName, SqlSortOrder.ASC, SqlSortLanguage.BINARY).limit(1).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        if (lexoRankRows.size() != 1) {
            throw new LexoRankIntegrityException(String.format("Expected to find one rank row, but found %s rows", lexoRankRows.size()));
        }
        return lexoRankRows.get(0);
    }

    @Override
    public LexoRankRow[] getRowByRankAndPreviousRow(long fieldId, String rank) {
        LexoRankDaoContext ctx = this.getContext();
        String fieldIdColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = ctx.getEntityDetails().getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + rankColumnName + " <= ?", fieldId, rank).orderBy(rankColumnName, SqlSortOrder.DESC, SqlSortLanguage.BINARY).limit(2).build();
        List<LexoRankRow> lexoRankRows = this.find(selectStatement);
        return lexoRankRows.toArray(new LexoRankRow[0]);
    }

    @Override
    public Set<Long> findIssueIdsByFieldId(long fieldId) {
        final HashSet issueIds = Sets.newHashSet();
        this.ao.stream(LexoRankAO.class, Query.select((String)"ID, ISSUE_ID, TYPE").where("FIELD_ID = ? AND TYPE = ?", new Object[]{fieldId, LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId()}), (EntityStreamCallback)new EntityStreamCallback<LexoRankAO, Long>(){

            public void onRowRead(LexoRankAO lexoRankAO) {
                issueIds.add(lexoRankAO.getIssueId());
            }
        });
        return issueIds;
    }

    @Override
    public Collection<Long> findFieldIdsInLexoRankTable() {
        LexoRankDaoContext lexoRankDaoContext = this.getContext();
        LexoRankEntityDetails entityDetails = lexoRankDaoContext.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, lexoRankDaoContext.getDatabaseType()).select("DISTINCT " + fieldIdColumnName).build();
        ResultSet resultSet = null;
        HashSet<Long> result = new HashSet<Long>();
        try {
            resultSet = selectStatement.execute();
            while (resultSet.next()) {
                Long fieldId = resultSet.getLong(1);
                result.add(fieldId);
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to query Field Ids", (Throwable)e);
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            selectStatement.close();
        }
        return result;
    }

    @Override
    public Map<Long, Long> ranksCountByField() {
        LexoRankDaoContext lexoRankDaoContext = this.getContext();
        LexoRankEntityDetails entityDetails = lexoRankDaoContext.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, lexoRankDaoContext.getDatabaseType()).select(fieldIdColumnName + ", COUNT(DISTINCT " + rankColumnName + ")").emptyWhere().groupBy(fieldIdColumnName, new Object[0]).build();
        ResultSet resultSet = null;
        try {
            resultSet = selectStatement.execute();
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            while (resultSet.next()) {
                Long fieldId = resultSet.getLong(1);
                Long distinctCount = resultSet.getLong(2);
                result.put(fieldId, distinctCount);
            }
            HashMap<Long, Long> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to query LexoRank rows", (Throwable)e);
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            selectStatement.close();
        }
    }

    @Override
    public LockOutcome acquireLock(Long rowIdToLock) {
        return this.acquireLockByRowIds(Sets.newHashSet((Object[])new Long[]{rowIdToLock}));
    }

    @Override
    public LockOutcome acquireLock(LexoRankRow rowToLock) {
        return this.acquireLockByRowIds(Sets.newHashSet((Object[])new Long[]{rowToLock.getId()}));
    }

    @Override
    public LockOutcome acquireLock(Set<LexoRankRow> rowsToLock) {
        Iterable rowIdsToLock = Iterables.transform(rowsToLock, (Function)new Function<LexoRankRow, Long>(){

            public Long apply(@Nullable LexoRankRow lexoRankRow) {
                return lexoRankRow.getId();
            }
        });
        return this.acquireLockByRowIds(Sets.newHashSet((Iterable)rowIdsToLock));
    }

    @Override
    public LockOutcome acquireLock(LexoRankRow[] rowsToLock) {
        Iterable rowIdsToLock = Iterables.transform((Iterable)Lists.newArrayList((Object[])rowsToLock), (Function)new Function<LexoRankRow, Long>(){

            public Long apply(@Nullable LexoRankRow lexoRankRow) {
                return lexoRankRow.getId();
            }
        });
        return this.acquireLockByRowIds(Sets.newLinkedHashSet((Iterable)rowIdsToLock));
    }

    @Override
    public LockOutcome acquireLockByFieldId(Long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ?", fieldId).build();
        int rowCountForFieldId = this.count(selectStatement);
        if (rowCountForFieldId == 0) {
            return LockOutcome.fail(LockOutcome.FailReason.NO_RECORDS, "No rows for fieldId[" + fieldId + "]", new Object[0]);
        }
        Lock lock = Lock.newLock(rowCountForFieldId);
        String whereClause = fieldIdColumnName + " = ?" + " AND (" + lockHashColumnName + " IS NULL" + " OR " + lockTimeColumnName + " < ?)";
        long lockTimeout = System.currentTimeMillis() - 1500L;
        SqlUpdateStatement updateStatement = SqlUpdateStatement.builder(entityDetails).set(lockHashColumnName + " = ?, " + lockTimeColumnName + " = ?").withParam(lock.hash).withParam(lock.time).where(whereClause, fieldId, lockTimeout).build();
        try {
            int numberOfUpdates = updateStatement.execute();
            if (numberOfUpdates != lock.getCount()) {
                lock.setCount(numberOfUpdates);
                return LockOutcome.failButWithLock(lock, LockOutcome.FailReason.NEEDS_RETRY, "Failed to lock all entities. Expected %d but locked only %d", lock.getCount(), numberOfUpdates);
            }
            return LockOutcome.lock(lock);
        }
        catch (SQLException exc) {
            this.log.warn("Error while locking %d entities with lock %s.", lock.getCount(), lock.hash);
            this.log.exception(exc);
            return LockOutcome.fail(LockOutcome.FailReason.SQL_EXCEPTION, "Exception while locking '%s'", exc.getMessage());
        }
    }

    @Override
    public void releaseLock(Lock lock) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        SqlUpdateStatement updateStatement = SqlUpdateStatement.builder(entityDetails).set(lockHashColumnName + " = ?, " + lockTimeColumnName + " = ?").withParam(null, 12).withParam(null, -5).where(lockHashColumnName + " = ?", lock.hash).build();
        try {
            int unlockedCount = updateStatement.executeWithTimeout(2);
            if (unlockedCount != lock.getCount()) {
                this.log.warn("Unlocked entities count (%d) does not correspond to the number of locked entites (%d) for lock %s", unlockedCount, lock.getCount(), lock.hash);
            }
        }
        catch (SQLException exc) {
            this.log.warn("Error while unlocking %d entities with lock %s.", lock.getCount(), lock.hash);
            this.log.exception(exc);
        }
    }

    @Override
    public LockProcessOutcome<ServiceOutcome<Void>> deleteByIssueId(Lock lock, Long issueId) {
        return this.deleteByLimitedIssueIds(lock, Lists.newArrayList((Object[])new Long[]{issueId}));
    }

    @Override
    public LockProcessOutcome<ServiceOutcome<Void>> deleteByLimitedIssueIds(Lock lock, List<Long> issueIds) {
        if (issueIds.isEmpty()) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok());
        }
        if (issueIds.size() >= 1000) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "issueIds cannot have more than 1000 elements as certain databases have limited 'IN clause' sizes", new Object[0]));
        }
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String issueIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).count().where(issueIdColumnName + " IN (" + this.makeQuestionsList(issueIds) + ")", issueIds.toArray()).build();
        int rowCountForIssueIds = this.count(selectStatement);
        if (rowCountForIssueIds == 0) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok());
        }
        String whereClause = issueIdColumnName + " IN (" + this.makeQuestionsList(issueIds) + ")" + " AND " + lockHashColumnName + " = ? " + " AND " + lockTimeColumnName + " = ?" + " AND " + lockTimeColumnName + " >= ?";
        ArrayList<Object> whereParams = new ArrayList<Object>();
        whereParams.addAll(issueIds);
        whereParams.add(lock.hash);
        whereParams.add(lock.time);
        whereParams.add(System.currentTimeMillis() - 1500L);
        SqlDeleteStatement deleteStatement = SqlDeleteStatement.builder(entityDetails).where(whereClause, whereParams.toArray()).build();
        try {
            int deletedRowsCount = deleteStatement.execute();
            lock.setCount(lock.getCount() - deletedRowsCount);
            if (deletedRowsCount < rowCountForIssueIds) {
                return LockProcessOutcome.retry();
            }
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok());
        }
        catch (SQLException e) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "sql exception", e.getMessage()));
        }
    }

    @Override
    public LockProcessOutcome<ServiceOutcome<Void>> deleteByFieldId(Lock lock, Long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ?", fieldId).build();
        int rowCountForFieldId = this.count(selectStatement);
        if (rowCountForFieldId == 0) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok());
        }
        String whereClause = fieldIdColumnName + " = ?" + " AND " + lockHashColumnName + " = ? " + " AND " + lockTimeColumnName + " = ?" + " AND " + lockTimeColumnName + " >= ?";
        SqlDeleteStatement deleteStatement = SqlDeleteStatement.builder(entityDetails).where(whereClause, fieldId, lock.hash, lock.time, System.currentTimeMillis() - 1500L).build();
        try {
            int deletedRowsCount = deleteStatement.execute();
            if (deletedRowsCount == 0) {
                return LockProcessOutcome.retry();
            }
            lock.setCount(lock.getCount() - deletedRowsCount);
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok());
        }
        catch (SQLException e) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "sql exception", e.getMessage()));
        }
    }

    @Override
    public LockProcessOutcome<ServiceOutcome<Void>> deleteByFieldIdAndIssueId(Lock lock, Long fieldId, Long issueId) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String issueIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ? AND " + issueIdColumnName + " = ?", fieldId, issueId).build();
        int rowCountForFieldId = this.count(selectStatement);
        if (rowCountForFieldId == 0) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok());
        }
        String whereClause = fieldIdColumnName + " = ?" + " AND " + issueIdColumnName + " = ?" + " AND " + lockHashColumnName + " = ? " + " AND " + lockTimeColumnName + " = ?" + " AND " + lockTimeColumnName + " >= ?";
        SqlDeleteStatement deleteStatement = SqlDeleteStatement.builder(entityDetails).where(whereClause, fieldId, issueId, lock.hash, lock.time, System.currentTimeMillis() - 1500L).build();
        try {
            int deletedRowsCount = deleteStatement.execute();
            if (deletedRowsCount == 0) {
                return LockProcessOutcome.retry();
            }
            lock.setCount(lock.getCount() - deletedRowsCount);
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok());
        }
        catch (SQLException e) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "sql exception", e.getMessage()));
        }
    }

    @Override
    public ServiceOutcome<Void> deleteAll() {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        SqlDeleteStatement deleteStatement = SqlDeleteStatement.builder(entityDetails).build();
        try {
            deleteStatement.execute();
            return ServiceOutcomeImpl.ok();
        }
        catch (SQLException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "sql exception", e.getMessage());
        }
    }

    @Override
    public LockProcessOutcome<ServiceOutcome<LexoRankRow>> save(Lock lock, LexoRankRow lexoRankRow) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String idColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ID);
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String issueIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String bucketColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.BUCKET);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        String typeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.TYPE);
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        StringBuilder setClauseBuilder = new StringBuilder().append(fieldIdColumnName).append(" = ?, ").append(issueIdColumnName).append(" = ?, ").append(bucketColumnName).append(" = ?, ").append(rankColumnName).append(" = ?, ").append(typeColumnName).append(" = ?");
        StringBuilder whereClauseBuilder = new StringBuilder().append(idColumnName).append(" = ? AND ").append(lockHashColumnName).append(" = ? AND ").append(lockTimeColumnName).append(" = ? AND ").append(lockTimeColumnName).append(" >= ?");
        SqlUpdateStatement updateStatement = SqlUpdateStatement.builder(entityDetails).set(setClauseBuilder.toString()).withParam(lexoRankRow.getFieldId()).withParam(lexoRankRow.getIssueId()).withParam(lexoRankRow.getBucket()).withParam(lexoRankRow.getRank()).withParam(lexoRankRow.getType().getId()).where(whereClauseBuilder.toString(), lexoRankRow.getId(), lock.hash, lock.time, System.currentTimeMillis() - 1500L).build();
        try {
            int updatedRowsCount = updateStatement.execute();
            if (updatedRowsCount == 0) {
                return LockProcessOutcome.retry();
            }
            return LockProcessOutcome.value(ServiceOutcomeImpl.ok(lexoRankRow));
        }
        catch (SQLException exc) {
            return LockProcessOutcome.value(ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "sql exception", exc.getMessage()));
        }
    }

    @Override
    public ServiceOutcome<LexoRankRow> unlockedSave(LexoRankRow lexoRankRow) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String idColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ID);
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String issueIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String bucketColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.BUCKET);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        String typeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.TYPE);
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        StringBuilder setClauseBuilder = new StringBuilder().append(fieldIdColumnName).append(" = ?, ").append(issueIdColumnName).append(" = ?, ").append(bucketColumnName).append(" = ?, ").append(rankColumnName).append(" = ?, ").append(typeColumnName).append(" = ?, ").append(lockHashColumnName).append(" = ?, ").append(lockTimeColumnName).append(" = ? ");
        SqlUpdateStatement updateStatement = SqlUpdateStatement.builder(entityDetails).set(setClauseBuilder.toString()).withParam(lexoRankRow.getFieldId(), -5).withParam(lexoRankRow.getIssueId(), -5).withParam(lexoRankRow.getBucket(), 4).withParam(lexoRankRow.getRank(), 12).withParam(lexoRankRow.getType().getId(), 4).withParam(lexoRankRow.getLockHash(), 12).withParam(lexoRankRow.getLockTime(), -5).where(idColumnName + " = ?", lexoRankRow.getId()).build();
        try {
            int updatedRowsCount = updateStatement.execute();
            if (updatedRowsCount == 0) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "unlockedSave updated 0 rows", new Object[0]);
            }
            return ServiceOutcomeImpl.ok(lexoRankRow);
        }
        catch (SQLException exc) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "sql exception", exc.getMessage());
        }
    }

    @Override
    public LexoRankRow[] getRowsAtBalanceBoundaryForFieldId(Long fieldId, LexoRankBucket bucketBeingMigratedFrom, LexoRankBucket bucketBeingMigratedTo) {
        LexoRankDaoContext ctx = this.getContext();
        if (bucketBeingMigratedFrom.equals((Object)bucketBeingMigratedTo)) {
            throw new IllegalArgumentException("BucketBeingMigratedFrom must be different from BucketBeingMigratedTo");
        }
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        String bucketColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.BUCKET);
        ArrayList rowsAtBoundary = Lists.newArrayList();
        boolean migratingToLargerBucket = bucketBeingMigratedFrom.compareTo(bucketBeingMigratedTo) < 0;
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + bucketColumnName + " = ?", fieldId, bucketBeingMigratedFrom.intValue()).orderBy(rankColumnName, migratingToLargerBucket ? SqlSortOrder.DESC : SqlSortOrder.ASC, SqlSortLanguage.BINARY).limit(1).build();
        List<LexoRankRow> resultRows = this.find(selectStatement);
        if (resultRows.size() == 1) {
            rowsAtBoundary.add(resultRows.get(0));
        }
        if ((resultRows = this.find(selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + bucketColumnName + " = ?", fieldId, bucketBeingMigratedTo.intValue()).orderBy(rankColumnName, migratingToLargerBucket ? SqlSortOrder.ASC : SqlSortOrder.DESC, SqlSortLanguage.BINARY).limit(1).build())).size() == 1) {
            rowsAtBoundary.add(resultRows.get(0));
        }
        return rowsAtBoundary.toArray(new LexoRankRow[0]);
    }

    @Override
    public boolean existsRankForFieldId(Long rankFieldId, String rank) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ? AND " + rankColumnName + " = ?", rankFieldId, rank).build();
        Integer existingRankCount = this.count(selectStatement);
        return existingRankCount > 0;
    }

    @Override
    public Map<String, Long> countDuplicateRowsForFieldId(Long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).select(rankColumnName + ", COUNT(1)").where(fieldIdColumnName + " = ?", fieldId).groupBy(rankColumnName, new Object[0]).having("COUNT(1) > 1", new Object[0]).build();
        HashMap duplicateRanksCount = Maps.newHashMap();
        ResultSet resultSet = null;
        try {
            resultSet = selectStatement.execute();
            while (resultSet.next()) {
                String duplicateRank = resultSet.getString(1);
                Long duplicateCount = resultSet.getLong(2);
                duplicateRanksCount.put(duplicateRank, duplicateCount);
            }
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            selectStatement.close();
        }
        return duplicateRanksCount;
    }

    @Override
    public List<LexoRankRow> listByFieldIdAndRank(Long fieldId, String rank) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(fieldIdColumnName + " = ? AND " + rankColumnName + " = ?", fieldId, rank).build();
        return this.find(selectStatement);
    }

    @Override
    public Integer getRowCountForFieldId(Long fieldId) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ?", fieldId).build();
        return this.count(selectStatement);
    }

    @Override
    public long getRowCountInBucket(Long fieldId, LexoRankBucket containingBucket) {
        return this.getRowCountInBucket(fieldId, containingBucket, null);
    }

    @Override
    public long getRowCountInBucket(Long fieldId, LexoRankBucket containingBucket, @Nullable LexoRankRow.RankRowType rankRowType) {
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String bucketColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.BUCKET);
        String typeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.TYPE);
        SqlSelectStatement selectStatement = rankRowType == null ? SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ? AND " + bucketColumnName + " = ?", fieldId, containingBucket.intValue()).build() : SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ? AND " + bucketColumnName + " = ? AND " + typeColumnName + " = ?", fieldId, containingBucket.intValue(), rankRowType.getId()).build();
        return this.count(selectStatement).intValue();
    }

    @Override
    public long getNumRowsWithInvalidBucket(Long fieldId) {
        long numRowsWithInvalidBucket = 0L;
        LexoRankDaoContext ctx = this.getContext();
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String fieldIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String bucketColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.BUCKET);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        for (LexoRankBucket bucket : LexoRankBucket.values()) {
            SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, ctx.getDatabaseType()).count().where(fieldIdColumnName + " = ? AND ( " + bucketColumnName + " <> ? OR " + bucketColumnName + " IS NULL ) AND " + rankColumnName + " LIKE ?", fieldId, bucket.intValue(), bucket.intValue() + "|%").build();
            numRowsWithInvalidBucket += (long)this.count(selectStatement).intValue();
        }
        return numRowsWithInvalidBucket;
    }

    @Override
    public List<Long> listIssueIdsBetween(long startIdInclusive, long endIdInclusive) {
        LexoRankDaoContext lexoRankDaoContext = this.getContext();
        LexoRankEntityDetails entityDetails = lexoRankDaoContext.getEntityDetails();
        String issueIdColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        SqlSelectStatement selectStatement = SqlSelectStatement.builder(entityDetails, lexoRankDaoContext.getDatabaseType()).select("DISTINCT " + issueIdColumnName).where(issueIdColumnName + " >= ? AND " + issueIdColumnName + " <= ?", startIdInclusive, endIdInclusive).build();
        ResultSet resultSet = null;
        try {
            resultSet = selectStatement.execute();
            LinkedList issueIds = Lists.newLinkedList();
            while (resultSet.next()) {
                issueIds.add(resultSet.getLong(1));
            }
            LinkedList linkedList = issueIds;
            return linkedList;
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to query LexoRank rows", (Throwable)e);
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            selectStatement.close();
        }
    }

    private LexoRankRow[] findByOptionalItemIds(@Nullable Long fieldId, Iterable<Long> issueIds) {
        if (!issueIds.iterator().hasNext()) {
            return new LexoRankRow[0];
        }
        ArrayList allRows = Lists.newArrayList();
        LexoRankDaoContext ctx = this.getContext();
        for (List partition : Iterables.partition(issueIds, (int)1000)) {
            SqlSelectStatement selectStatement = this.createItemSelectStatement(fieldId, partition, ctx);
            ResultSet resultSet = null;
            try {
                resultSet = selectStatement.execute();
                allRows.addAll(this.getLexoRankRows(resultSet));
            }
            catch (SQLException e) {
                throw new DataAccessException("Failed to query LexoRank rows", (Throwable)e);
            }
            finally {
                Common.closeQuietly((ResultSet)resultSet);
                selectStatement.close();
            }
        }
        return allRows.toArray(new LexoRankRow[allRows.size()]);
    }

    private SqlSelectStatement createItemSelectStatement(@Nullable Long rankDomain, Collection<Long> itemIds, LexoRankDaoContext ctx) {
        String typeColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.TYPE);
        String issueIdColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.ISSUE_ID);
        String fieldIdColumnName = ctx.getColumnName(LexoRankAO.ColumnDetails.FIELD_ID);
        String whereClause = typeColumnName + " = ? AND " + issueIdColumnName + " IN (" + this.makeQuestionsList(itemIds) + ")";
        ArrayList<Number> whereParams = new ArrayList<Number>();
        whereParams.add(LexoRankRow.RankRowType.ISSUE_RANK_ROW.getId());
        whereParams.addAll(itemIds);
        if (rankDomain != null) {
            whereClause = whereClause + " AND " + fieldIdColumnName + " = ?";
            whereParams.add(rankDomain);
        }
        return SqlSelectStatement.builder(ctx.getEntityDetails(), ctx.getDatabaseType()).select(ctx.allColumnNamesInNaturalOrder()).where(whereClause, whereParams.toArray()).build();
    }

    protected List<LexoRankRow> find(SqlSelectStatement selectStatement) {
        List<LexoRankRow> list;
        ResultSet resultSet = null;
        try {
            this.log.debug(" LexoRank Query : %s", selectStatement.toSql());
            resultSet = selectStatement.execute();
            list = this.getLexoRankRows(resultSet);
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                Common.closeQuietly(resultSet);
                selectStatement.close();
                throw throwable;
            }
        }
        Common.closeQuietly((ResultSet)resultSet);
        selectStatement.close();
        return list;
    }

    private List<LexoRankRow> getLexoRankRows(ResultSet resultSet) throws SQLException {
        ArrayList lexoRankList = Lists.newArrayList();
        while (resultSet.next()) {
            LexoRankRow lexoRankRow = LexoRankRow.builder().id(resultSet.getLong(LexoRankAO.ColumnDetails.ID.getNaturalOrderIndex())).forRankField(resultSet.getLong(LexoRankAO.ColumnDetails.FIELD_ID.getNaturalOrderIndex())).forIssue(resultSet.getLong(LexoRankAO.ColumnDetails.ISSUE_ID.getNaturalOrderIndex())).withRank(resultSet.getString(LexoRankAO.ColumnDetails.RANK.getNaturalOrderIndex())).ofType(resultSet.getInt(LexoRankAO.ColumnDetails.TYPE.getNaturalOrderIndex())).withLock(resultSet.getString(LexoRankAO.ColumnDetails.LOCK_HASH.getNaturalOrderIndex()), resultSet.getLong(LexoRankAO.ColumnDetails.LOCK_TIME.getNaturalOrderIndex())).build();
            lexoRankList.add(lexoRankRow);
        }
        return lexoRankList;
    }

    private LockOutcome acquireLockByRowIds(Set<Long> rowIdsToLock) {
        LexoRankDaoContext ctx = this.getContext();
        if (rowIdsToLock.isEmpty()) {
            return LockOutcome.fail(LockOutcome.FailReason.NO_RECORDS, "No entities specified for the lock", new Object[0]);
        }
        LexoRankEntityDetails entityDetails = ctx.getEntityDetails();
        String idColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.ID);
        String lockHashColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_HASH);
        String lockTimeColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.LOCK_TIME);
        Long lockTimeout = System.currentTimeMillis() - 1500L;
        ArrayList<Long> whereParams = new ArrayList<Long>();
        whereParams.addAll(rowIdsToLock);
        whereParams.add(lockTimeout);
        Lock lock = Lock.newLock(rowIdsToLock.size());
        SqlUpdateStatement updateStatement = SqlUpdateStatement.builder(entityDetails).set(lockHashColumnName + " = ?, " + lockTimeColumnName + " = ?").withParam(lock.hash).withParam(lock.time).where(idColumnName + " IN (" + this.makeQuestionsList(rowIdsToLock) + ")" + " AND (" + lockHashColumnName + " IS NULL OR " + lockTimeColumnName + " < ?)", whereParams.toArray()).build();
        try {
            int numberOfUpdates = updateStatement.executeWithTimeout(2);
            if (numberOfUpdates != lock.getCount()) {
                lock.setCount(numberOfUpdates);
                return LockOutcome.failButWithLock(lock, LockOutcome.FailReason.NEEDS_RETRY, "Failed to lock all entities. Expected %d but locked only %d", rowIdsToLock.size(), lock.getCount());
            }
            return LockOutcome.lock(lock);
        }
        catch (SQLException exc) {
            this.log.warn("Error while locking %d entities with lock %s.", lock.getCount(), lock.hash);
            this.log.exception(exc);
            return LockOutcome.fail(LockOutcome.FailReason.SQL_EXCEPTION, "Exception while locking '%s'", exc.getMessage());
        }
    }

    private Integer count(SqlSelectStatement selectStatement) {
        ResultSet resultSet = null;
        try {
            resultSet = selectStatement.execute();
            if (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                return n;
            }
            Integer n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            Common.closeQuietly((ResultSet)resultSet);
            selectStatement.close();
        }
    }

    private String makeQuestionsList(Collection<?> items) {
        StringBuilder sb = new StringBuilder();
        for (Object o : items) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("?");
        }
        return sb.toString();
    }
}

