/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.util.database.DatabaseType;
import com.atlassian.greenhopper.util.database.DatabaseUtils;
import com.atlassian.jira.exception.DataAccessException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.stream.Collectors;
import net.java.ao.Common;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;

public class LexoRankDaoContext {
    private EntityManager entityManager;
    private DatabaseType databaseType;
    private LexoRankEntityDetails entityDetails;
    private final boolean collationWorking;

    public LexoRankDaoContext(EntityManager entityManager, boolean collationWorking) {
        this.entityManager = entityManager;
        this.collationWorking = collationWorking;
        this.entityDetails = LexoRankEntityDetails.get(entityManager, LexoRankAO.ColumnDetails.list(), collationWorking);
    }

    public DatabaseProvider getDbProvider() {
        return this.entityManager.getProvider();
    }

    public DatabaseType getDatabaseType() {
        if (this.databaseType == null) {
            Connection connection = null;
            try {
                connection = this.getDbProvider().getConnection();
                this.databaseType = DatabaseUtils.resolveDatabaseType(connection);
            }
            catch (SQLException e) {
                throw new DataAccessException((Throwable)e);
            }
            finally {
                Common.closeQuietly((Connection)connection);
            }
        }
        return this.databaseType;
    }

    public LexoRankEntityDetails getEntityDetails() {
        return this.entityDetails;
    }

    public String getColumnName(LexoRankAO.ColumnDetails columnDetails) {
        return this.entityDetails.getColumnName(columnDetails);
    }

    public boolean isCollationWorking() {
        return this.collationWorking;
    }

    public String allColumnNamesInNaturalOrder() {
        return LexoRankAO.ColumnDetails.list().stream().map(columnDetails -> this.getEntityDetails().getColumnName((LexoRankAO.ColumnDetails)((Object)columnDetails))).collect(Collectors.joining(","));
    }
}

