/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.lexorank;

import com.atlassian.greenhopper.manager.lexorank.SqlBulkInsertBuilder;
import net.java.ao.DatabaseProvider;

public class CommonSqlBulkInsertBuilder
extends SqlBulkInsertBuilder {
    protected CommonSqlBulkInsertBuilder(DatabaseProvider dbProvider) {
        super(dbProvider);
    }

    @Override
    public SqlBulkInsertBuilder row(Object ... cellValues) {
        StringBuilder row = new StringBuilder("(");
        for (Object cellValue : cellValues) {
            if (cellValue instanceof Number) {
                row.append(cellValue + ",");
                continue;
            }
            row.append("'" + cellValue + "',");
        }
        row.deleteCharAt(row.length() - 1);
        row.append(")");
        this.rows.add(row.toString());
        return this;
    }

    @Override
    public String build() {
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.dbProvider.withSchema(this.tableName) + "(");
        for (String columnName : this.columnNames) {
            sql.append(this.dbProvider.processID(columnName) + ",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") VALUES ");
        for (String row : this.rows) {
            sql.append(row + ",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(";");
        return sql.toString();
    }
}

