/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issuelink;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issuelink.EpicLinkManager;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.IssueIndexService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.issuelink.EpicLinkTypeService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicLinkManagerImpl
implements EpicLinkManager {
    @Autowired
    private IssueLinkManager issueLinkManager;
    @Autowired
    private EpicLinkTypeService epicLinkTypeService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private IssueUpdater issueUpdater;
    @Autowired
    private IssueIndexService issueIndexService;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private IssueIndexManager issueIndexManager;
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());

    @Override
    @Nonnull
    public Option<Issue> getEpic(Issue child) {
        IssueLinkType epicLinkType = this.getEpicLinkType();
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        if (child.getIssueTypeObject().equals(epicIssueType)) {
            return Option.none();
        }
        List inwardLinks = this.issueLinkManager.getInwardLinks(child.getId());
        for (IssueLink inwardLink : inwardLinks) {
            Issue epic;
            if (!inwardLink.getIssueLinkType().equals(epicLinkType) || !(epic = inwardLink.getSourceObject()).getIssueTypeObject().equals(epicIssueType)) continue;
            return Option.some((Object)epic);
        }
        return Option.none();
    }

    @Override
    public List<Issue> getIssuesInEpic(Issue epic) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Long epicLinkId = this.epicLinkTypeService.getOrCreateEpicLinkType().getId();
        List links = this.issueLinkManager.getOutwardLinks(epic.getId());
        for (IssueLink link : links) {
            if (!link.getLinkTypeId().equals(epicLinkId)) continue;
            issues.add(link.getDestinationObject());
        }
        return issues;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> disassociateIssuesFromEpic(ApplicationUser user, @Nonnull Issue epic) {
        IssueLinkType epicLinkType = this.getEpicLinkType();
        List outwardLinks = this.issueLinkManager.getOutwardLinks(epic.getId());
        HashSet<Issue> issuesToRemove = new HashSet<Issue>();
        for (IssueLink link : outwardLinks) {
            if (!link.getLinkTypeId().equals(epicLinkType.getId())) continue;
            Issue issue = link.getDestinationObject();
            issuesToRemove.add(issue);
        }
        return this.disassociateEpicFromIssues(user, issuesToRemove, true);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> disassociateEpicFromIssues(ApplicationUser user, @Nonnull Set<Issue> issues, boolean createChangeItemAndDispatchEvent) {
        return this.associateIssuesWithEpic(user, (Option<Issue>)Option.none(), issues, createChangeItemAndDispatchEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ServiceOutcome<Void> associateIssuesWithEpic(ApplicationUser user, @Nonnull Option<Issue> epic, @Nonnull Set<Issue> issues, boolean createChangeItemAndDispatchEvent) {
        long startTime;
        block10: {
            ServiceOutcome<Void> serviceOutcome;
            if (issues.isEmpty()) {
                return ServiceOutcomeImpl.ok();
            }
            this.issueIndexManager.hold();
            try {
                startTime = System.currentTimeMillis();
                ServiceOutcome<Void> dbOutcome = this.updateLinksForIssues(user, epic, issues, createChangeItemAndDispatchEvent);
                if (dbOutcome.isValid()) break block10;
                serviceOutcome = ServiceOutcomeImpl.error(dbOutcome);
            }
            catch (Throwable throwable) {
                try {
                    startTime = System.currentTimeMillis();
                    this.issueIndexManager.release();
                    long endTime = System.currentTimeMillis();
                    this.logger.debug("Time taken for Indexing for association = %d ms", endTime - startTime);
                }
                catch (IndexException e) {
                    this.logger.error("Uncaught exception while updating database; now IndexException when trying to release index hold: %s", e.getMessage());
                }
                throw throwable;
            }
            try {
                startTime = System.currentTimeMillis();
                this.issueIndexManager.release();
                long endTime = System.currentTimeMillis();
                this.logger.debug("Time taken for Indexing for association = %d ms", endTime - startTime);
            }
            catch (IndexException e) {
                this.logger.error("Uncaught exception while updating database; now IndexException when trying to release index hold: %s", e.getMessage());
            }
            return serviceOutcome;
        }
        long endTime = System.currentTimeMillis();
        this.logger.debug("Time taken for DB calls for association = %d ms", endTime - startTime);
        try {
            startTime = System.currentTimeMillis();
            this.issueIndexManager.release();
            endTime = System.currentTimeMillis();
            this.logger.debug("Time taken for Indexing for association = %d ms", endTime - startTime);
        }
        catch (IndexException e) {
            this.logger.error("Uncaught exception while updating database; now IndexException when trying to release index hold: %s", e.getMessage());
        }
        return ServiceOutcomeImpl.ok();
    }

    /*
     * WARNING - void declaration
     */
    private ServiceOutcome<Void> updateLinksForIssues(ApplicationUser user, @Nonnull Option<Issue> epic, @Nonnull Set<Issue> issues, boolean createChangeItemAndDispatchEvent) {
        HashMap epicsWithIssuesRemoved = new HashMap();
        for (Issue issue : issues) {
            ServiceOutcome<Void> linkOutcome;
            ServiceOutcome<Option<Issue>> removeOutcome = this.removeLinkedEpic(user, issue);
            if (!removeOutcome.isValid()) {
                return ServiceOutcomeImpl.error(removeOutcome);
            }
            if (!removeOutcome.getValue().isEmpty()) {
                Issue previousLink = (Issue)removeOutcome.getValue().get();
                if (!epicsWithIssuesRemoved.containsKey(previousLink)) {
                    epicsWithIssuesRemoved.put(previousLink, new HashSet());
                }
                ((Set)epicsWithIssuesRemoved.get(previousLink)).add(issue);
            }
            if (!epic.isEmpty() && !(linkOutcome = this.createLink(user, (Issue)epic.get(), issue)).isValid()) {
                return ServiceOutcomeImpl.error(linkOutcome);
            }
            if (createChangeItemAndDispatchEvent) {
                this.createEpicLinkChangeItemsForChild(user, issue, (Issue)removeOutcome.getValue().getOrNull(), (Issue)epic.getOrNull());
            }
            MutableIssue mutableIssue = this.issueManager.getIssueObject(issue.getId());
            this.issueIndexService.reIndex((Issue)mutableIssue);
        }
        if (!epic.isEmpty()) {
            void var7_11;
            Issue epicIssue = (Issue)epic.getOrNull();
            Set<Issue> set = issues;
            Set issuesRemovedFromTargetEpic = (Set)epicsWithIssuesRemoved.remove(epicIssue);
            if (issuesRemovedFromTargetEpic != null) {
                HashSet<Issue> hashSet = new HashSet<Issue>(set);
                hashSet.removeAll(issuesRemovedFromTargetEpic);
            }
            this.recordChangesForEpic(user, epicIssue, (Set<Issue>)var7_11, Collections.emptySet());
        }
        for (Map.Entry entry : epicsWithIssuesRemoved.entrySet()) {
            this.recordChangesForEpic(user, (Issue)entry.getKey(), Collections.emptySet(), (Set)entry.getValue());
        }
        return ServiceOutcomeImpl.ok();
    }

    @Nonnull
    private ServiceOutcome<Option<Issue>> removeLinkedEpic(ApplicationUser user, Issue child) {
        IssueLinkType epicLinkType = this.getEpicLinkType();
        List inwardLinks = this.issueLinkManager.getInwardLinks(child.getId());
        Issue previousEpic = null;
        for (IssueLink link : inwardLinks) {
            if (!link.getLinkTypeId().equals(epicLinkType.getId())) continue;
            previousEpic = link.getSourceObject();
            this.logger.info("Removing previously linked epic '%s' from issue '%s'", previousEpic.getKey(), child.getKey());
            this.issueLinkManager.removeIssueLink(link, user);
        }
        if (previousEpic != null) {
            return ServiceOutcomeImpl.ok(Option.some(previousEpic));
        }
        return ServiceOutcomeImpl.ok(Option.none());
    }

    @Nonnull
    private ServiceOutcome<Void> createLink(ApplicationUser user, Issue epic, Issue child) {
        IssueLinkType epicLinkType = this.getEpicLinkType();
        try {
            this.issueLinkManager.createIssueLink(epic.getId(), child.getId(), epicLinkType.getId(), null, user);
            return ServiceOutcomeImpl.ok();
        }
        catch (CreateException e) {
            this.logger.exception(e);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.epic.associate.error.could.not.create", epic.getKey(), child.getKey());
        }
    }

    private void recordChangesForEpic(ApplicationUser user, Issue epic, Set<Issue> issuesAdded, Set<Issue> issuesRemoved) {
        if (issuesAdded.isEmpty() && issuesRemoved.isEmpty()) {
            return;
        }
        try {
            ArrayList<ChangeItemBean> changeItems = new ArrayList<ChangeItemBean>();
            for (Issue issueAdded : issuesAdded) {
                changeItems.add(this.createChangeItemBeanForEpicChild((Either<Issue, Issue>)Either.left((Object)issueAdded)));
            }
            for (Issue issueRemoved : issuesRemoved) {
                changeItems.add(this.createChangeItemBeanForEpicChild((Either<Issue, Issue>)Either.right((Object)issueRemoved)));
            }
            this.createChangeItemsForEpics(epic, changeItems, user);
        }
        catch (Exception e) {
            this.logger.error("Error occurred while creating change item for epic child link for '%s'.", epic.getId());
            this.logger.exception(e);
        }
    }

    private void createEpicLinkChangeItemsForChild(ApplicationUser user, @Nonnull Issue child, @Nullable Issue oldEpic, @Nullable Issue newEpic) {
        CustomField epicLinkField = this.epicCustomFieldService.getDefaultEpicLinkField();
        try {
            if (oldEpic != null && newEpic != null) {
                if (oldEpic.equals((Object)newEpic)) {
                    return;
                }
                ChangeItemBean cib = this.createChangeItemBeanForEpic(oldEpic, newEpic, epicLinkField);
                this.createChangeItemAndDispatchEventForIssue(child, cib, user);
            } else if (oldEpic != null) {
                ChangeItemBean cib = this.createChangeItemBeanForEpic(oldEpic, null, epicLinkField);
                this.createChangeItemAndDispatchEventForIssue(child, cib, user);
            } else if (newEpic != null) {
                ChangeItemBean cib = this.createChangeItemBeanForEpic(null, newEpic, epicLinkField);
                this.createChangeItemAndDispatchEventForIssue(child, cib, user);
            }
        }
        catch (Exception e) {
            this.logger.error("Error occurred while creating change item for epic link for '%s'.", child.getId());
            this.logger.exception(e);
        }
    }

    private ChangeItemBean createChangeItemBeanForEpic(Issue oldEpic, Issue newEpic, CustomField epicLinkField) {
        String oldKey = null;
        String oldId = null;
        String newKey = null;
        String newId = null;
        if (oldEpic != null) {
            oldId = oldEpic.getId().toString();
            oldKey = oldEpic.getKey();
        }
        if (newEpic != null) {
            newId = newEpic.getId().toString();
            newKey = newEpic.getKey();
        }
        return new ChangeItemBean("custom", epicLinkField.getName(), oldId, oldKey, newId, newKey);
    }

    private ChangeItemBean createChangeItemBeanForEpicChild(Either<Issue, Issue> issueAddedOrRemoved) {
        String fromValue = null;
        String fromString = null;
        String toValue = null;
        String toString = null;
        if (issueAddedOrRemoved.isLeft()) {
            Either.LeftProjection added = issueAddedOrRemoved.left();
            toValue = ((Issue)added.get()).getId().toString();
            toString = ((Issue)added.get()).getKey();
        } else {
            Either.RightProjection removed = issueAddedOrRemoved.right();
            fromValue = ((Issue)removed.get()).getId().toString();
            fromString = ((Issue)removed.get()).getKey();
        }
        return new ChangeItemBean("custom", "Epic Child", fromValue, fromString, toValue, toString);
    }

    private void createChangeItemAndDispatchEventForIssue(Issue issue, ChangeItemBean changeItemBean, ApplicationUser remoteUser) {
        this.createChangeItem(issue, Collections.singletonList(changeItemBean), remoteUser, true);
    }

    private void createChangeItemsForEpics(Issue issue, List<ChangeItemBean> changeItemBeans, ApplicationUser remoteUser) {
        this.createChangeItem(issue, changeItemBeans, remoteUser, false);
    }

    private void createChangeItem(Issue issue, List<ChangeItemBean> changeItemBeans, ApplicationUser remoteUser, boolean dispatchEvent) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue, issue, EventType.ISSUE_UPDATED_ID, remoteUser);
        issueUpdateBean.setDispatchEvent(dispatchEvent);
        issueUpdateBean.setChangeItems(changeItemBeans);
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    private IssueLinkType getEpicLinkType() {
        return this.epicLinkTypeService.getOrCreateEpicLinkType();
    }
}

