/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.issuetypes;

import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.greenhopper.manager.issue.issuetypes.AbstractIssueTypeProvider;
import com.atlassian.greenhopper.manager.issue.issuetypes.IssueTypeMetadata;
import com.atlassian.greenhopper.manager.properties.ManagedIssueTypePropertyDao;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.SubTaskManager;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoryIssueTypeProvider
extends AbstractIssueTypeProvider {
    public static final String STORY_ISSUE_TYPE_NAME = "gh.issue.story";
    public static final String STORY_ISSUE_TYPE_DESC = "gh.issue.storydesc";
    private static final IssueTypeMetadata STORY_ISSUE_TYPE_METADATA = IssueTypeMetadata.builder().setNameKey("gh.issue.story").setDescriptionKey("gh.issue.storydesc").setSubTask(false).setIconUrl("/images/icons/issuetypes/story.svg").build();
    private final ManagedIssueTypePropertyDao managedIssueTypePropertyDao;

    @Autowired
    public StoryIssueTypeProvider(IssueTypeManager issueTypeManager, I18nFactoryService i18nFactoryService, ClusterLockService clusterLockService, SubTaskManager subTaskManager, ManagedIssueTypePropertyDao managedIssueTypePropertyDao) {
        super(issueTypeManager, i18nFactoryService, clusterLockService, subTaskManager, STORY_ISSUE_TYPE_METADATA);
        this.managedIssueTypePropertyDao = managedIssueTypePropertyDao;
    }

    @Override
    @Nullable
    protected String getStoredIssueTypeId() {
        return this.managedIssueTypePropertyDao.getStoryProperty();
    }

    @Override
    protected void setStoredIssueTypeId(@Nullable String id) {
        this.managedIssueTypePropertyDao.setStoryProperty(id);
    }
}

