/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.issuetypes;

import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.issuetypes.AbstractIssueTypeProvider;
import com.atlassian.greenhopper.manager.issue.issuetypes.EpicIssueTypeChangedEvent;
import com.atlassian.greenhopper.manager.issue.issuetypes.IssueTypeMetadata;
import com.atlassian.greenhopper.manager.properties.ManagedIssueTypePropertyDao;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicIssueTypeProvider
extends AbstractIssueTypeProvider {
    public static final String EPIC_ISSUE_TYPE_NAME = "gh.issue.epic";
    public static final String EPIC_ISSUE_TYPE_DESC = "gh.issue.epicdesc";
    private static final IssueTypeMetadata EPIC_ISSUE_TYPE_METADATA = IssueTypeMetadata.builder().setNameKey("gh.issue.epic").setDescriptionKey("gh.issue.epicdesc").setSubTask(false).setIconUrl("/images/icons/issuetypes/epic.svg").build();
    private final EventPublisher eventPublisher;
    private final ManagedIssueTypePropertyDao managedIssueTypePropertyDao;
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());

    @Autowired
    public EpicIssueTypeProvider(IssueTypeManager issueTypeManager, I18nFactoryService i18nFactoryService, EventPublisher eventPublisher, ClusterLockService clusterLockService, SubTaskManager subTaskManager, ManagedIssueTypePropertyDao managedIssueTypePropertyDao) {
        super(issueTypeManager, i18nFactoryService, clusterLockService, subTaskManager, EPIC_ISSUE_TYPE_METADATA);
        this.eventPublisher = eventPublisher;
        this.managedIssueTypePropertyDao = managedIssueTypePropertyDao;
    }

    @Override
    @Nullable
    protected String getStoredIssueTypeId() {
        return this.managedIssueTypePropertyDao.getEpicProperty();
    }

    @Override
    protected void setStoredIssueTypeId(@Nullable String id) {
        this.managedIssueTypePropertyDao.setEpicProperty(id);
    }

    @Override
    protected void afterIssueTypeIsProduced(IssueType issueType) {
        if (!this.doesIssueTypeExist()) {
            if (issueType == null) {
                this.logger.error("Epic issue type should exist and not be null after creation", new Object[0]);
            } else {
                this.logger.error("'%s' issue type with id '%s' should exist after creation", issueType.getName(), issueType.getId());
            }
            return;
        }
        this.eventPublisher.publish((Object)new EpicIssueTypeChangedEvent());
    }
}

