/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.issuetypes;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.issuetypes.IssueTypeMetadata;
import com.atlassian.greenhopper.manager.issue.issuetypes.ManagedIssueTypeProvider;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class AbstractIssueTypeProvider
implements ManagedIssueTypeProvider {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final IssueTypeManager issueTypeManager;
    private final I18nFactoryService i18nFactoryService;
    private final ClusterLockService clusterLockService;
    private final SubTaskManager subTaskManager;
    private final IssueTypeMetadata issueTypeMetadata;

    public AbstractIssueTypeProvider(IssueTypeManager issueTypeManager, I18nFactoryService i18nFactoryService, ClusterLockService clusterLockService, SubTaskManager subTaskManager, IssueTypeMetadata issueTypeMetadata) {
        this.issueTypeManager = issueTypeManager;
        this.i18nFactoryService = i18nFactoryService;
        this.clusterLockService = clusterLockService;
        this.subTaskManager = subTaskManager;
        this.issueTypeMetadata = issueTypeMetadata;
    }

    @Override
    public IssueType getOrCreateIssueType() {
        IssueType issueType = this.getIssueTypeOrNull();
        if (issueType == null) {
            issueType = this.ensureIssueTypeIsAvailable();
            this.afterIssueTypeIsProduced(issueType);
        }
        return issueType;
    }

    @Override
    public boolean doesIssueTypeExist() {
        return this.getIssueTypeOrNull() != null;
    }

    @Nullable
    protected abstract String getStoredIssueTypeId();

    protected abstract void setStoredIssueTypeId(@Nullable String var1);

    private IssueType getIssueTypeOrNull() {
        if (this.issueTypeMetadata.isSubTask() && !this.subTaskManager.isSubTasksEnabled()) {
            this.log.info("Requesting the ID for issue type '%s' but it is a sub-task type and sub-tasks are currently disabled", this.issueTypeMetadata.getNameKey());
            return null;
        }
        this.log.debug("Requesting the ID for issue type: ", this.issueTypeMetadata.getNameKey());
        String id = this.getStoredIssueTypeId();
        if (id != null) {
            this.log.debug("Issue Type ID '%s' has been set -- verifying that the issue type still exists", id);
            IssueType issueType = this.issueTypeManager.getIssueType(id);
            if (issueType != null) {
                this.log.debug("Issue Type with ID '%s' exists", issueType.getId());
                return issueType;
            }
            this.log.debug("Issue Type with ID '%s' did not exist", id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IssueType ensureIssueTypeIsAvailable() {
        String issueTypeProviderName = this.getClass().getName();
        ClusterLock lock = this.clusterLockService.getLockForName(issueTypeProviderName);
        lock.lock();
        IssueType issueType = null;
        try {
            issueType = this.getIssueTypeOrNull();
            if (issueType == null) {
                issueType = this.produceIssueType();
                this.setStoredIssueTypeId(issueType.getId());
            }
        }
        finally {
            lock.unlock();
        }
        return issueType;
    }

    private IssueType produceIssueType() {
        I18n2 defaultI18n = this.i18nFactoryService.getI18n();
        IssueType issueType = this.tryFindExistingIssueTypeInsteadOfCreating(defaultI18n);
        if (issueType == null) {
            String name = defaultI18n.getText(this.issueTypeMetadata.getNameKey());
            String description = defaultI18n.getText(this.issueTypeMetadata.getDescriptionKey());
            if (this.issueTypeMetadata.isSubTask()) {
                if (!this.subTaskManager.isSubTasksEnabled()) {
                    throw new UnsupportedOperationException(String.format("Attempted to create a sub-task issue type '%s' when sub-tasks are disabled in JIRA.", name));
                }
                issueType = this.issueTypeManager.createSubTaskIssueType(name, description, this.issueTypeMetadata.getIconUrl());
            } else {
                issueType = this.issueTypeManager.createIssueType(name, description, this.issueTypeMetadata.getIconUrl());
            }
            this.log.info("Created Issue Type with ID '%s'", issueType.getId());
        }
        return issueType;
    }

    @VisibleForTesting
    protected IssueType tryFindExistingIssueTypeInsteadOfCreating(I18n2 i18n) {
        Collection issueTypes = this.issueTypeManager.getIssueTypes();
        for (IssueType issueType : issueTypes) {
            if (!i18n.getText(this.issueTypeMetadata.getNameKey()).equals(issueType.getName()) || this.issueTypeMetadata.isSubTask() != issueType.isSubTask()) continue;
            return issueType;
        }
        return null;
    }

    protected void afterIssueTypeIsProduced(IssueType issueType) {
    }
}

