/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.fields;

import com.atlassian.greenhopper.manager.issue.fields.ManagedFieldRestrictor;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.ErrorCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagedFieldRestrictorImpl
implements ManagedFieldRestrictor {
    @Autowired
    private ManagedConfigurationItemService managedConfigurationItemService;
    private final Logger logger = LoggerFactory.getLogger(ManagedFieldRestrictor.class);

    @Override
    public ServiceOutcome<Void> lockField(CustomField field) {
        ManagedConfigurationItem managedConfigurationItem = this.managedConfigurationItemService.getManagedCustomField(field);
        if (managedConfigurationItem.getConfigurationItemAccessLevel() == ConfigurationItemAccessLevel.LOCKED) {
            return ServiceOutcomeImpl.ok(null);
        }
        managedConfigurationItem = managedConfigurationItem.newBuilder().setManaged(true).setConfigurationItemAccessLevel(ConfigurationItemAccessLevel.LOCKED).setSource("com.pyxis.greenhopper.jira:reference-select-locked").setDescriptionI18nKey("gh.customfield.locked.desc").build();
        ServiceOutcome resultOutcome = this.managedConfigurationItemService.updateManagedConfigurationItem(managedConfigurationItem);
        this.logger.info("Configuration locked for field " + field.getFieldName() + " with " + resultOutcome.isValid());
        return ServiceOutcomeImpl.from((ErrorCollection)resultOutcome.getErrorCollection(), null);
    }
}

