/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.fields;

import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldUtil;
import com.atlassian.greenhopper.customfield.MetadataCFType;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.issue.fields.CustomFieldUpdateService;
import com.atlassian.greenhopper.manager.issue.fields.CustomFieldContextConfigurator;
import com.atlassian.greenhopper.manager.issue.fields.ManagedCustomFieldProvider;
import com.atlassian.greenhopper.manager.issue.fields.ManagedFieldConfigurationRestorer;
import com.atlassian.greenhopper.manager.issue.fields.ManagedFieldRestrictor;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagedFieldConfigurationRestorerImpl
implements ManagedFieldConfigurationRestorer {
    public static final boolean HIDDEN_IN_FIELD_LAYOUT = false;
    private final LoggerWrapper log = LoggerWrapper.with(ManagedFieldConfigurationRestorerImpl.class);
    private final CustomFieldContextConfigurator customFieldContextConfigurator;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldUpdateService customFieldUpdateService;
    private final ManagedFieldRestrictor managedFieldRestrictor;
    private final Collection<ManagedCustomFieldProvider> fieldProviders;
    private final I18nFactoryService i18nFactoryService;
    private final FieldLayoutManager fieldLayoutManager;

    @Autowired
    public ManagedFieldConfigurationRestorerImpl(CustomFieldContextConfigurator customFieldContextConfigurator, CustomFieldManager customFieldManager, CustomFieldUpdateService customFieldUpdateService, ManagedFieldRestrictor managedFieldRestrictor, Collection<ManagedCustomFieldProvider> fieldProviders, I18nFactoryService i18nFactoryService, FieldLayoutManager fieldLayoutManager) {
        this.customFieldContextConfigurator = customFieldContextConfigurator;
        this.customFieldManager = customFieldManager;
        this.customFieldUpdateService = customFieldUpdateService;
        this.managedFieldRestrictor = managedFieldRestrictor;
        this.fieldProviders = fieldProviders;
        this.i18nFactoryService = i18nFactoryService;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    public ServiceResult restoreAndLockFields() {
        List<CustomField> customFields = this.allManagedFields();
        I18n2 i18n = this.i18nFactoryService.getI18n();
        ErrorCollection errors = new ErrorCollection();
        for (CustomField customField : customFields) {
            com.atlassian.greenhopper.service.ServiceOutcome<Void> outcome = this.restoreAndLockField(i18n, customField);
            if (!outcome.isInvalid()) continue;
            errors.addAllErrors(outcome.getErrors());
        }
        this.customFieldManager.refresh();
        return ServiceResultImpl.from(errors);
    }

    @Override
    public com.atlassian.greenhopper.service.ServiceOutcome<Boolean> isCustomFieldCorrectlyConfigured(CustomField customField) {
        CustomFieldType customFieldType = customField.getCustomFieldType();
        if (!(customFieldType instanceof MetadataCFType)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "The given customfield[name=%s] is not managed by GreenHopper", customField.getName());
        }
        MetadataCFType metadataCFType = (MetadataCFType)customFieldType;
        CustomFieldMetadata customFieldMetadata = metadataCFType.getMetadata();
        I18n2 i18n = this.i18nFactoryService.getI18n();
        return this.restoreField(i18n, customField, customFieldMetadata);
    }

    private com.atlassian.greenhopper.service.ServiceOutcome<Void> restoreAndLockField(I18n2 i18n, CustomField customField) {
        MetadataCFType metadataCFType = (MetadataCFType)customField.getCustomFieldType();
        CustomFieldMetadata customFieldMetadata = metadataCFType.getMetadata();
        com.atlassian.greenhopper.service.ServiceOutcome<Boolean> restoreOutcome = this.restoreField(i18n, customField, customFieldMetadata);
        if (restoreOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(restoreOutcome);
        }
        if (!restoreOutcome.getValue().booleanValue()) {
            return ServiceOutcomeImpl.ok();
        }
        return this.lockField(customField, customFieldMetadata);
    }

    private com.atlassian.greenhopper.service.ServiceOutcome<Boolean> restoreField(I18n2 i18n, CustomField customField, CustomFieldMetadata customFieldMetadata) {
        try {
            if (customField.getCustomFieldSearcher() == null) {
                CustomFieldSearcher searcher = this.customFieldManager.getCustomFieldSearcher(customFieldMetadata.getFieldSearcher());
                this.customFieldUpdateService.updateFieldSearcher(customField, searcher);
                this.log.info("Custom field searcher for field '%s' is missing. Restored it to '%s'", customField.getName(), customFieldMetadata.getFieldSearcher());
            }
            this.restoreCustomFieldDescription(i18n, customField, customFieldMetadata);
            this.restoreFieldConfiguration(customField, customFieldMetadata);
            return ServiceOutcomeImpl.ok(this.restoreContextOnFieldRestoration(i18n, customField, customFieldMetadata));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Unable to fix the '%s' custom field configuration. Reason: %s", customField.getName(), exc.getMessage());
        }
    }

    private void restoreCustomFieldDescription(I18n2 i18n, CustomField customField, CustomFieldMetadata customFieldMetadata) {
        String applicableFieldDescription = i18n.getText(customFieldMetadata.getFieldDescription());
        if (!StringUtils.equals((CharSequence)customField.getDescription(), (CharSequence)applicableFieldDescription)) {
            this.customFieldUpdateService.updateDescription(customField, applicableFieldDescription);
        }
    }

    private boolean restoreContextOnFieldRestoration(I18n2 i18n, CustomField customField, CustomFieldMetadata customFieldMetadata) {
        Option<FieldConfig> config = CustomFieldUtil.getOneAndOnlyConfig(customField);
        return config.isEmpty() || this.customFieldContextConfigurator.ensureFieldHasCorrectContext(i18n, customField, customFieldMetadata);
    }

    @Override
    public Collection<Pair<CustomField, CustomFieldMetadata>> ensureFieldsHaveCorrectContextConfiguration() {
        List<CustomField> customFields = this.allManagedFields();
        I18n2 i18n = this.i18nFactoryService.getI18n();
        ArrayList result = Lists.newArrayListWithCapacity((int)customFields.size());
        for (CustomField customField : customFields) {
            MetadataCFType metadataCFType = (MetadataCFType)customField.getCustomFieldType();
            CustomFieldMetadata customFieldMetadata = metadataCFType.getMetadata();
            this.customFieldContextConfigurator.ensureFieldHasCorrectContext(i18n, customField, customFieldMetadata);
            result.add(Pair.pair((Object)customField, (Object)customFieldMetadata));
        }
        return result;
    }

    private List<CustomField> allManagedFields() {
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        for (ManagedCustomFieldProvider provider : this.fieldProviders) {
            customFields.addAll(provider.getManagedFields());
        }
        return customFields;
    }

    private void restoreFieldConfiguration(CustomField customField, CustomFieldMetadata customFieldMetadata) {
        I18n2 i18n = this.i18nFactoryService.getI18n();
        this.fieldLayoutManager.updateFieldLayoutItemAttributesForCustomField(customField, i18n.getText(customFieldMetadata.getFieldDescription()), customFieldMetadata.isRequireField(), false);
    }

    private com.atlassian.greenhopper.service.ServiceOutcome<Void> lockField(CustomField customField, CustomFieldMetadata customFieldMetadata) {
        if (!customFieldMetadata.isLockField()) {
            return ServiceOutcomeImpl.ok();
        }
        ServiceOutcome<Void> serviceOutcome = this.managedFieldRestrictor.lockField(customField);
        return ServiceOutcomeImpl.from(serviceOutcome.getErrorCollection());
    }
}

