/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.manager.issue.fields;

import com.atlassian.greenhopper.manager.issue.fields.IssueTypeRestorer;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTypeRestorerImpl
implements IssueTypeRestorer {
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private IssueTypeManager issueTypeManager;

    @Override
    public void restoreIssueTypes() {
        I18n2 i18n = this.i18nFactoryService.getI18n();
        this.restoreIssueType(i18n, IssueTypePrototype.EPIC, "gh.issue.epicdesc");
        this.restoreIssueType(i18n, IssueTypePrototype.STORY, "gh.issue.storydesc");
    }

    private void restoreIssueType(I18n2 i18n, IssueTypePrototype issueTypePrototype, String epicDescKey) {
        if (this.issueTypeService.hasIssueTypeId(issueTypePrototype)) {
            IssueType issueType = this.issueTypeService.getIssueType(issueTypePrototype);
            String applicableDescription = i18n.getText(epicDescKey);
            if (!StringUtils.equals((CharSequence)issueType.getDescription(), (CharSequence)applicableDescription)) {
                this.issueTypeManager.editIssueType(issueType, issueType.getName(), applicableDescription, issueType.getIconUrl());
            }
        }
    }
}

